#include <stdio.h>
#include <string.h>
#include "vogle.h"
#include "vopl.h"

void	log_axis(), lin_axis();

extern	double log10();

/*
 * formatlabel
 *
 *	chose a "nice" format for an axis label, awful at the moment.
 */
formatlabel(alabel, form)
	float	alabel;
	char	*form;
{
	int	i, j;

	if (ABS(alabel) < 1.0e-9)
		alabel = 0.0;

	if ((ABS(alabel) > 999999.0) || (ABS(alabel) < 0.000001))
		sprintf(form, "%.4g", alabel);
	else 
		sprintf(form, "%f", alabel);

	/*
	 * if there is no 'e' in there or there is a dot then
	 * eat trailing zeros.....
	 */
	if ((strchr(form, 'e') == (char *)NULL &&
	    strchr(form, 'E') == (char *)NULL) &&
	    strchr(form, '.') != (char *)NULL) {
		i = strlen(form) - 1;
		while (i >= 0 && form[i] == '0') 
			i--;

		if (form[i] == '.')
			i--;

		form[++i] = '\0';
		if (form[0] == '\0') {
			form[0] = '0';
			form[1] = '\0';
		}
	}
}

/*
 * axistitle
 *
 *	Draws an x, y or z axis, with or without annotation, tickmarks etc
 */
void
axistitle(title, ax)
	char	*title, ax;
{
	char	**s, err_buf[EBUF_SIZE];

	/*
	 * save the goddam title somewhere....
	 */
	switch (ax) {
	case 'x':
	case 'X':
		s = &plotdev.axes[XIND].title;
		break;
	case 'y':
	case 'Y':
		s = &plotdev.axes[YIND].title;
		break;
	case 'z':
	case 'Z':
		s = &plotdev.axes[ZIND].title;
		break;
	default:
		sprintf(err_buf, "axistitle: unknown axis '%c'", ax);
		vopl_error(err_buf);
	}

	*s = savestr(*s, title);
}

/*
 * drawaxis
 *
 *	Draws an x, y or z axis, with or without annotation, tickmarks etc
 */
void
drawaxis(axis)
	char	axis;
{
	int	ind;
	char	err_buf[EBUF_SIZE];

	switch (axis) {
	case 'x':
	case 'X':
		ind = XIND;
		break;
	case 'y':
	case 'Y':
		ind = YIND;
		break;
	case 'z':
	case 'Z':
		ind = ZIND;
		break;
	default:
		sprintf(err_buf, "drawaxis: unknown axis '%c'", axis);
		vopl_error(err_buf);
	}

	if (!plotdev.axes[ind].scaleset) { 
		plotdev.axes[ind].min = -1.0;
		plotdev.axes[ind].max = 1.0;
	}

	if (plotdev.axes[ind].scaling == LOGARITHMIC)
		log_axis(ind);
	else
		lin_axis(ind);
}

/*
 * drawaxes2
 *
 *	Draws the x and y axes, with or without annotation, tickmarks etc
 */
void
drawaxes2()
{
	int	axis;

	for (axis = 0; axis < AXES; axis++)
		if (!plotdev.axes[axis].scaleset) { 
			plotdev.axes[axis].min = -1.0;
			plotdev.axes[axis].max = 1.0;
		}

	if (plotdev.axes[XIND].scaling == LOGARITHMIC) 
		log_axis(XIND);
	else
		lin_axis(XIND);

	if (plotdev.axes[YIND].scaling == LOGARITHMIC) 
		log_axis(YIND);
	else 
		lin_axis(YIND);
}

/*
 * drawaxes
 *
 *	Draws an x, y, and z axes, with or without annotation, tickmarks etc
 */
void
drawaxes()
{
	int	axis;

	for (axis = 0; axis < AXES; axis++) {
		if (!plotdev.axes[axis].scaleset) { 
			plotdev.axes[axis].min = -1.0;
			plotdev.axes[axis].max = 1.0;
		}

		if (plotdev.axes[axis].scaling == LOGARITHMIC) 
			log_axis(axis);
		else
			lin_axis(axis);
	}
}

/*
 * lin_axis
 *
 *	draw a linear axis
 */
void
lin_axis(axis)
	int		axis;
{
	float 		x, y, sx, sy;
	float		alabel;
	int 		i, count;
        char		form[50], err_buf[EBUF_SIZE];
	axisdata	ax;

	
	pushattributes();
	pushmatrix();
	pushviewport();

	ortho2(-1.0, 1.0, -1.0, 1.0);

	clipping(0);

	switch (axis) {
	case XIND:
		textsize(TEXTWIDTH, TEXTHEIGHT);
		move2(XMIN, YMIN);
		draw2(XMAX, YMIN);

		textang(0.0);
		centertext(1);

		ax = plotdev.axes[XIND];

		x = ax.max - ax.min;
		count = x / ax.div + 0.5;

		for (i = 0; i <= count; i++) {
			sx = i * (XMAX - XMIN) / x * ax.div + XMIN;
			if (plotdev.grid) 
				if (!(i % plotdev.grid)) {
					move2(sx, YMAX);
					draw2(sx, YMIN);
				}
		

			if (ax.ntspacing && !(i % ax.ntspacing)) {
				move2(sx, YMIN);
				draw2(sx, YMIN - LINELEN);
			}
		
			if (ax.annotate) {
				alabel = ax.min + ax.div * i;
				if (ax.format)
					sprintf(form, ax.format, alabel);
				else
					formatlabel(alabel, form);

				move2(sx, YMIN - LINELEN - 1.1 * TEXTHEIGHT / 2);
				drawstr(form);
			}
		}

		if (ax.title != (char *)NULL) {
			textang(0.0);
			centertext(1);
			x = 0.5 * (XMAX - XMIN) + XMIN;
			y = (YMIN - 6.0 * TEXTWIDTH);
			textsize(1.3 * TEXTWIDTH, 1.3 * TEXTHEIGHT);
			move2(x, y);
			drawstr(ax.title);
		}
		break;
	case YIND:
		textsize(TEXTWIDTH, TEXTHEIGHT);
		clipping(0);
		centertext(0);
		textang(0.0);

		move2(XMIN, YMIN);
		draw2(XMIN, YMAX);

		ax = plotdev.axes[YIND];

		y = ax.max - ax.min;

		for (i = 0; i <=  (y / ax.div + 0.5); i++) {
			sy = i * (YMAX - YMIN) / y * ax.div + YMIN;

			if (plotdev.grid) 
				if (!(i % plotdev.grid)) {
					move2(XMIN, sy);
					draw2(XMAX, sy);
				}

			if (ax.ntspacing && !(i % ax.ntspacing)) {
				move2(XMIN, sy);
				draw2(XMIN - LINELEN, sy);
			}

			if (ax.annotate) {
				alabel = ax.min + ax.div * i;
				if (ax.format)
					sprintf(form, ax.format, alabel);
				else
					formatlabel(alabel, form);

				move2(XMIN - strlength(form) - 2 * LINELEN, sy - TEXTHEIGHT / 2);
				drawstr(form);
			}
		}

		if (ax.title != (char *)NULL) {
			x = XMIN - 7.0 * TEXTWIDTH;
			y = 0.5 * (YMAX - YMIN) + YMIN;
			move2(x, y);
			textang(90.0);
			centertext(1);
			textsize(1.3 * TEXTWIDTH, 1.3 * TEXTHEIGHT);
			drawstr(ax.title);
			textang(0.0);
		}
		break;
	case ZIND:
		vopl_error("Z-Axis not yet implemented");
		break;
	default:
		sprintf(err_buf, "axis: unknown axis: %d", axis);
		vopl_error(err_buf);
	}

	popviewport();
	popmatrix();
	popattributes();
	clipping(1);
}


/*
 * log_axis
 *
 *	Does a logarithmic axis with exponential style annotation
 */
void
log_axis(axis)
	int	axis;
{

	float 		x, y, sx, sy;
	float		alabel, ldiv;
	int 		i;
        char		form[21], err_buf[EBUF_SIZE];
	axisdata	ax;
	
	pushattributes();
	pushmatrix();
	pushviewport();

	ortho2(-1.0, 1.0, -1.0, 1.0);

	clipping(0);

	switch (axis) {
	case XIND:
		textsize(TEXTWIDTH, TEXTHEIGHT);
		move2(XMIN, YMIN);
		draw2(XMAX, YMIN);

		textang(0.0);
		centertext(0);

		ax = plotdev.axes[XIND];

		/*
		 * Get the minimum exponent value.
		 */
		alabel = (float)log10((double)ax.min);

		for (i = 0; i <= ax.nticks; i++) {
			sx = i * (XMAX - XMIN) / (ax.nticks) + XMIN;

			if (plotdev.grid)
				if (!(i % plotdev.grid)) {
					move2(sx, YMAX);
					draw2(sx, YMIN);
				}

			if (ax.ntspacing && !(i % ax.ntspacing)) {
				move2(sx, YMIN);
				draw2(sx, YMIN - LINELEN);
			}
			
			if (ax.annotate) {
				formatlabel(alabel, form);

				textsize(0.7 * TEXTWIDTH, 0.7 * TEXTHEIGHT);
				move2(sx + 0.5 * TEXTWIDTH, YMIN - LINELEN - 0.8 * TEXTHEIGHT);
				drawstr(form);
				rmove2(-strlength(form), 0.0);
				textsize(TEXTWIDTH, TEXTHEIGHT);
				rmove2(-1.3 * TEXTWIDTH, -0.9 * TEXTHEIGHT);
				drawstr("10");
			}
			alabel += ax.div;
		}

		if (ax.title != (char *)NULL) {
			centertext(1);
			x = 0.5 * (XMAX - XMIN) + XMIN;
			y = (YMIN - 6.0 * TEXTWIDTH);
			move2(x, y);
			textsize(1.3 * TEXTWIDTH, 1.3 * TEXTHEIGHT);
			drawstr(ax.title);
		}
		break;
	case YIND:
		textsize(TEXTWIDTH, TEXTHEIGHT);
		clipping(0);
		centertext(0);
		textang(0.0);

		move2(XMIN, YMIN);
		draw2(XMIN, YMAX);

		ax = plotdev.axes[YIND];

		/*
		 * Get the minimum exponent value.
		 */
		alabel = (float)log10((double)ax.min);

		centertext(0);

		for (i = 0; i <= ax.nticks; i++) {
			sy = i * (YMAX - YMIN) / (ax.nticks) + YMIN;

			if (plotdev.grid) 
				if (!(i % plotdev.grid)) {
					move2(XMIN, sy);
					draw2(XMAX, sy);
				}

			if (ax.ntspacing && !(i % ax.ntspacing)) {
				move2(XMIN, sy);
				draw2(XMIN - LINELEN, sy);
			}

			if (ax.annotate) {
				formatlabel(alabel, form);
				textsize(0.7 * TEXTWIDTH, 0.7 * TEXTHEIGHT);
				move2(XMIN - strlength(form) - 2 * LINELEN, sy + 0.5 * TEXTHEIGHT);
				drawstr(form);
				rmove2(-strlength(form), -TEXTHEIGHT);
				textsize(TEXTWIDTH, TEXTHEIGHT);
				rmove2(-TEXTWIDTH, 0.0);
				drawstr("10");
			}
			alabel += ax.div;
		}

		if (ax.title != (char *)NULL) {
			x = XMIN - 7.0 * TEXTWIDTH;
			y = 0.5 * (YMAX - YMIN) + YMIN;
			move2(x, y);
			textang(90.0);
			centertext(1);
			textsize(1.3 * TEXTWIDTH, 1.3 * TEXTHEIGHT);
			drawstr(ax.title);
		}
		break;
	case ZIND:
		vopl_error("Z-Axis not yet implemented");
		break;
	default:
		sprintf(err_buf, "axis: unknown axis: %d", ax);
		vopl_error(err_buf);
	}

	popviewport();
	popmatrix();
	popattributes();
	clipping(1);
}
