#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/times.h>
#include <netinet/in.h>
#include <netdb.h>
#include <syslog.h>

#define	ART	"/usr/local/bin/art"

/*
 * readshort
 *
 *	read a short value from a socket.
 */
int
readshort(sock)
	int	sock;
{
	unsigned short	val;

	read(sock, &val, sizeof(unsigned short));
	return((int)ntohs(val));
}

/*
 * main driver to read in eagle ascii model files and then raytrace them.
 */
main(ac, av)
	int	ac;
	char	**av;
{
	FILE			*logf;
	struct sockaddr_in	caller;
	char			c, name[200], path[200], *argv[10], *envv[10];
	char			xbuf[100], ybuf[100];
	int			len, screenx, screeny, pid, status;
	unsigned char		*map;

	logf = fopen("/tmp/in.netartd", "w");

	c = ' ';
	read(0, &c, 1);		/* grab header character */

	while (c != 'Q') {

		/*
		 * read in working directory for art
		 */
		len = readshort(0);

		read(0, path, len);
		path[len] = 0;

		fprintf(logf, "path %s\n", path);
		fflush(logf);

		chdir(path);

		/*
		 * read in name of scene file
		 */
		len = readshort(0);

		read(0, name, len);
		name[len] = 0;

		screenx = readshort(0);
		screeny = readshort(0);

		sprintf(xbuf, "%d", screenx);
		sprintf(ybuf, "%d", screeny);

		fprintf(logf, "name %s - %d %d\n", name, screenx, screeny);
		fflush(logf);

		if ((pid = fork()) != 0)
			wait(&status);
		else {
			/*
			 * stop junk from art going through the sockets
			 */
			close(0);
			close(1);
			close(2);

			argv[0] = "art";
			argv[1] = name;
			argv[2] = xbuf;
			argv[3] = ybuf;
			argv[4] = (char *)NULL;

			envv[0] = (char *)NULL;

			execve(ART, argv, envv);
		}

		write(1, "D", 1);
		read(0, &c, 1);
		fprintf(logf, "%c\n", c);
		fflush(logf);
	}

	fclose(logf);

	exit(0);
}
