/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *			File: C_add_to_world.c
 *		      Author: Lisa Sobierajski 
 *			Date: 
 *		 Description: Create new objects and add them to the world 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include "C_volvis.h"

int C_add_sphere_to_world()
{
	extern int		C_create_volume_matrices();
	extern int		C_create_plane_equations();

	extern C_World		world;

	int			status;
	C_Volume		*volume;

	extern void		C_free_volume();

	status = C_create_volume( &volume, C_SINGLE_COLOR, C_SIMPLE_SHADE );

	if ( status == C_ERROR )
	{
		C_error_message("Can't Create Volume\n");
		return C_ERROR;
	}


	volume->x_size_voxels = 2;
	volume->y_size_voxels = 2;
	volume->z_size_voxels = 2;

	volume->x_size_units = 100.0;
	volume->y_size_units = 100.0;
	volume->z_size_units = 100.0;

	volume->data_type = C_GEOMETRIC_DATA;
	volume->data.geo_data = C_New( C_GeoData );	
	volume->data.geo_data->geo_type = C_SPHERE;

	C_create_volume_matrices( volume );
	C_create_plane_equations( volume );

	status = C_enter_volume( &world, volume, "sphere", (char *) NULL );

	if ( status == C_ERROR )
	{
		C_error_message("Can't Enter Volume in Volume Table. \n");

		C_free_volume( volume );

		return C_ERROR;
	}
}

int C_add_cylinder_to_world()
{
	extern int		C_create_volume_matrices();
	extern int		C_create_plane_equations();

	extern C_World		world;

	int			status;
	C_Volume		*volume;

	extern void		C_free_volume();

	status = C_create_volume( &volume, C_SINGLE_COLOR, C_SIMPLE_SHADE );

	if ( status == C_ERROR )
	{
		C_error_message("Can't Create Volume\n");
		return C_ERROR;
	}

	volume->x_size_voxels = 2;
	volume->y_size_voxels = 2;
	volume->z_size_voxels = 2;

	volume->x_size_units = 100.0;
	volume->y_size_units = 100.0;
	volume->z_size_units = 100.0;

	volume->data_type = C_GEOMETRIC_DATA;
	volume->data.geo_data = C_New( C_GeoData );	
	volume->data.geo_data->geo_type = C_CYLINDER;

	C_create_volume_matrices( volume );
	C_create_plane_equations( volume );

	status = C_enter_volume( &world, volume, "cylinder", (char *) NULL );

	if ( status == C_ERROR )
	{
		C_error_message("Can't Enter Volume in Volume Table. \n");

		C_free_volume( volume );

		return C_ERROR;
	}
}

int C_add_polygon_to_world()
{
	extern int		C_create_volume_matrices();
	extern int		C_create_plane_equations();

	extern C_World		world;

	int			status;
	C_Volume		*volume;
	C_FPosition		*vptr;

	extern void		C_free_volume();

	status = C_create_volume( &volume, C_SINGLE_COLOR, C_SIMPLE_SHADE );

	if ( status == C_ERROR )
	{
		C_error_message("Can't Create Volume\n");
		return C_ERROR;
	}

	volume->x_size_voxels = 2;
	volume->y_size_voxels = 2;
	volume->z_size_voxels = 2;

	volume->x_size_units = 100.0;
	volume->y_size_units = 1.0;
	volume->z_size_units = 100.0;

	volume->data_type = C_GEOMETRIC_DATA;
	volume->data.geo_data = C_New( C_GeoData );	
	volume->data.geo_data->geo_type = C_POLYGON;

	volume->data.geo_data->geo_object.polygon = C_New( C_Polygon );
	volume->data.geo_data->geo_object.polygon->plane.a = 0.0;
	volume->data.geo_data->geo_object.polygon->plane.b = 1.0;
	volume->data.geo_data->geo_object.polygon->plane.c = 0.0;
	volume->data.geo_data->geo_object.polygon->plane.d = -0.5;
	
	volume->data.geo_data->geo_object.polygon->num_vertices = 4;

	volume->data.geo_data->geo_object.polygon->vertices = vptr = 
		( C_FPosition *) malloc( 4 * sizeof( C_FPosition ) );

	vptr->x = 0.0;
	vptr->y = 0.5;
	vptr->z = 0.0;
	vptr++;
	
	vptr->x = 0.0;
	vptr->y = 0.5;
	vptr->z = 1.0;
	vptr++;

	vptr->x = 1.0;
	vptr->y = 0.5;
	vptr->z = 1.0;
	vptr++;

	vptr->x = 1.0;
	vptr->y = 0.5;
	vptr->z = 0.0;

	C_create_volume_matrices( volume );
	C_create_plane_equations( volume );

	status = C_enter_volume( &world, volume, "polygon", (char *) NULL );

	if ( status == C_ERROR )
	{
		C_error_message("Can't Enter Volume in Volume Table. \n");

		C_free_volume( volume );

		return C_ERROR;
	}
}

int C_add_point_light_to_world()
{
	extern C_World		world;

	C_Light			*new_light;

	extern void		C_free_light();

	new_light = C_New( C_Light );

	if ( !new_light )
	{
		C_error_message("Not enought memory to create light\n");
		return C_ERROR;
	}

	new_light->visible = TRUE;
	new_light->modifiable = FALSE;
	new_light->light_type = C_POINT_LIGHT;

	switch ( new_light->light_type )
	{
	    case C_POINT_LIGHT:

		new_light->light.light_point = C_New( C_PointLight );

		if ( !new_light->light.light_point )
		{
			C_error_message("Not enough memory to create light\n");
			free ( new_light );
			return C_ERROR;
		}

		new_light->light.light_point->orig_light_pos.x = 
		new_light->light.light_point->light_pos.x      = 0;
		new_light->light.light_point->orig_light_pos.y = 
		new_light->light.light_point->light_pos.y      = 0;
		new_light->light.light_point->orig_light_pos.z = 
		new_light->light.light_point->light_pos.z      = -500;

		C_identity3D( &(new_light->light.light_point->transform) );

		new_light->light.light_point->light_color.red = 
		new_light->light.light_point->light_color.green = 
		new_light->light.light_point->light_color.blue = 255;

		new_light->light.light_point->light_intensity = 100.0;


		break;
	}

	if ( ( C_enter_light( &world, new_light, "PLight", NULL ) ) == C_ERROR )
	{
		C_free_light( new_light );
		return C_ERROR;
	}

	return C_OK;
}

