/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: C_ide_selection.c
 *                  Author: He, Taosong
 *                  Date: 1/19/93
 *           Description: The C routines of selection queue operations
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/

#include <varargs.h>
#include <stdio.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_ide.h"
#include "MOTIF_windefs.h"

C_IDE_mouse_lookup mouse_lookup[C_MAX_OPERATION_NUMBER];
extern C_ide_operation_map 
rd_operation_map[C_MAX_RD_NUMBER][C_MAX_OPERATION_NUMBER];

void C_generate_mouse_map_common()
{

  int i;

  for (i=0; i< C_MAX_OPERATION_NUMBER; i++)
   {
     mouse_lookup[i].flag = 1;
     mouse_lookup[i].type = ButtonPress;
     switch (i)
       {
         case 0: 
          mouse_lookup[i].state = 0;
          mouse_lookup[i].button = Button1;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "click left");
          break;
         case 1:
          mouse_lookup[i].state = 0;
          mouse_lookup[i].button = Button2;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "click middle");
          break;
         case 2:
          mouse_lookup[i].state = 0;
          mouse_lookup[i].button = Button3;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "click right");
          break;
         case 3:
          mouse_lookup[i].state = ShiftMask;
          mouse_lookup[i].button = Button1;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "shift left");
          break;
         case 4:
          mouse_lookup[i].state = ShiftMask;
          mouse_lookup[i].button = Button2;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "shift middle");
          break;
         case 5:
          mouse_lookup[i].state =  ShiftMask;
          mouse_lookup[i].button = Button3;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "shift right");
          break;
         case 6:
          mouse_lookup[i].state =  ControlMask;
          mouse_lookup[i].button = Button1;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "ctrl left");
          break;
         case 7:
          mouse_lookup[i].state =  ControlMask;
          mouse_lookup[i].button = Button2;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "ctrl left");
          break;
         case 8:
          mouse_lookup[i].state =  ControlMask;
          mouse_lookup[i].button = Button3;
          sprintf(rd_operation_map[C_MOUSE][i].name, "%s", "ctrl right");
          break;
         default:
          mouse_lookup[i].flag = -1;
          break;
       }
   }
}
 
void C_lookup_mouse_op_map(event, operation_number)
XButtonEvent *event;
int *operation_number;
{
       int i;
       *operation_number = -1;

       for (i=0; i<C_MAX_OPERATION_NUMBER; i++)
        {

         if (mouse_lookup[i].flag != -1)
          {
           if ((mouse_lookup[i].type == event->type) &&
               (mouse_lookup[i].state == event->state) &&
               (mouse_lookup[i].button == event->button))
            {
              *operation_number = i;
              break;
            } 
          }
        }
}
         
          


     
   

