/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: X_ide_ui.c
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: X routines for input device user interface creation
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_volvis.h"
#include "C_ide.h"
#include "MOTIF_windefs.h"

/*       Global Variable: IDE_set_color
 *                         This variable defines the color representing 
 *                         different input device.
 */
 
XColor                 IDE_set_color[C_MAX_RD_NUMBER];

/*
 *        Procedure Name: X_define_token_color
 *          Return Value: void
 *       Input Variables:
 *      Output Variables:
 *      Update Variables:
 *      Global Variables: IDE_set_color
 *           Description: This function defines colors to represent different
 *                        input device.
 */

void X_define_token_color(display)
Display *display;
{
        XColor junk, junk2;
           
        extern C_WindowDefs    window_defs;

        Colormap        cmap; 

        cmap = window_defs.colormap;

        XLookupColor(   display, cmap, "Blue", &junk, &junk2 );
        IDE_set_color[C_MOUSE].pixel = C_Get_Pixel( junk2 );

        XLookupColor(   display, cmap,"turquoise4", &junk, &junk2 );
        IDE_set_color[C_SPACEBALL].pixel = C_Get_Pixel( junk2 );

        XLookupColor(   display, cmap,"purple4",&junk, &junk2 );
        IDE_set_color[C_ISOTRAK].pixel = C_Get_Pixel( junk2 );

        XLookupColor(   display, cmap,"red",  &junk, &junk2 );
        IDE_set_color[C_DATAGLOVE].pixel = C_Get_Pixel( junk2 );

        XLookupColor(   display, cmap,"magenta3", &junk, &junk2 );
        IDE_set_color[C_KEYBOARD].pixel = C_Get_Pixel( junk2 );
}





