/*
 * File :       hgserver.h
 *
 * Purpose :    Interface to class HGServer
 *
 * Created :    23 Apr 92    Keith Andrews, IICM
 *
 * Modified :   13 July 92    Keith Andrews, IICM
 *
 */


#ifndef hgserver_h
#define hgserver_h


/* PP #include <hyperg/Dispatch/rpcservice.h> */
#include <Dispatch/rpcservice.h>


/*
 * class HgServer
 *
 * Server Daemon.
 *
 *
 * Methods:
 *
 * virtual void createReader( int ) ;
 *
 * Forks to create a new reader process.
 * Called by the dispatcher, when Connect appears on port.
 *
 */


class HgServer : public RpcService {
  public:
     HgServer( int port ) ;
     virtual ~HgServer() {} ;
     int newfd() const { return _newfd ; }

  protected:
     virtual void createReader( int fd ) ;
     int _newfd ;
} ;


#endif
