/*
 * $Id: signal.h,v 1.4 1991/03/27 23:57:09 steve Exp $
 * $__Header$
 *
 * <signal.h> header-file for the SunOS 4.0.3 version of the Unidata
 * programming environment.
 *
 * REQUIRES:
 *	Definition of PROTO() macro (e.g. in <udposix.h>).
 *	Header-file "/usr//include/signal.h".
 */

#ifndef UDPOSIX_H_INCLUDED
#    include "/usr//include//signal.h"
#else

#ifndef	UD_SIGNAL_H_INCLUDED
#define	UD_SIGNAL_H_INCLUDED

/*
 *	Include the implementation-supplied header file.
 */
#include "/usr//include//signal.h"

/*
 *	Add missing definitions/declarations.
 */
typedef int	sigset_t;

extern int	sigemptyset	PROTO((sigset_t *mask));
extern int	sigaddset	PROTO((sigset_t *mask; int num));
extern int	sigdelset	PROTO((sigset_t *mask; int num));
extern int	sigprocmask	PROTO((int action; sigset_t *in_mask; 
				    sigset_t *out_mask));
/* Symbolic constants for the above "action" argument: */
#   define	SIG_BLOCK	    0x0001
#   define	SIG_UNBLOCK	    0x0002
#   define	SIG_SETMASK	    0x0004
extern int	sigsuspend	PROTO((sigset_t *mask));

#endif	/* UD_SIGNAL_H_INCLUDED undefined */

#endif	/* UDPOSIX_H_INCLUDED defined */
