/*
 * Test program for the Unidata udunits(3) library.
 */

#ifndef lint
    static char	rcsid[] = "$Id: udunits.c,v 1.2 1991/04/10 18:54:49 steve Exp $";
    static char	afsid[] = "$__Header$";
#endif

#include "udposix.h"
#include <limits.h>	/* for _POSIX_MAX_INPUT */
#include <stddef.h>	/* for size_t */
#include <stdio.h>	/* for I/O functions, and NULL */
#include <stdlib.h>	/* for EXIT_SUCCESS and EXIT_FAILURE */
#include <string.h>	/* for strlen() and memmove() */
#include <ctype.h>	/* for isspace() */
#include "udres.h"
#include "uderrmsg.h"	/* for udadvise() */
#include "udunits.h"

extern int	yydebug;

#define	ABS(x)		((x) < 0 ? -(x) : (x))


    static void
WriteError(name)
    const char	*name;
{
    perror(name);
    udadvise("%s: Error writing to standard output", name);
}


    static void
ReadError(name)
    const char	*name;
{
    perror(name);
    udadvise("%s: Error reading from standard output", name);
}


/*
 * Get a unit specification.
 */
   static int
GetSpec(prompt, spec, size)
    char	*prompt;
    char	*spec;
{
    int		status;
    static char	me[]	= "GetSpec";

    if (fputs(prompt, stdout) == EOF) {
	WriteError(me);
	status	= -1;
    } else if (fgets(spec, size, stdin) == NULL) {
	putchar('\n');
	if (feof(stdin)) {
	    status	=  0;
	} else {
	    ReadError(me);
	    status	= -1;
	}
    } else {
	/*
	 * Trim whitespace from the specification.
	 */
	char	*start, *stop;

	for (start = spec; *start != 0; ++start)
	    if (!isspace(*start))
		break;
	for (stop = start + strlen(start); stop > start; --stop)
	    if (!isspace(stop[-1]))
		break;
	*stop	= 0;
	(void)memmove((VOIDP)spec, (VOIDP)start, (size_t)(stop-start+1));

	status	= 1;
    }

    return status;
}


main(argc, argv)
    int			argc;
    char		**argv;
{
    int			status;
    char		HaveSpec[_POSIX_MAX_INPUT+1];
    char		WantSpec[_POSIX_MAX_INPUT+1];
    utUnit		HaveUnit, WantUnit;
    static char		*UnitsPath	= NULL;
    static char		me[]	= "main";
    static UdPosTab	PosTab	= {
	{"file", 1, UdInFile, (VOIDP)&UnitsPath, (int*)NULL, UDOPT},
	NULL
    };

    (void)uderrmode(UD_VERBOSE);

    if (udinit((UdKeyEntry*)NULL, PosTab, &argc, argv, (char*)NULL,
	(char*)NULL)) {

	if (utInit(UnitsPath) != 0) {
	    udadvise("%s: Couldn't initialize udunits(3) package", me);

	} else {
	    for (;;) {
		int		i;
		double	slope, intercept;

		i	=  GetSpec("You have: ", HaveSpec, sizeof(HaveSpec));
		if (i == -1)
		    goto failure;
		if (i == 0)
		    goto success;
		if (HaveSpec[0] == 0)
		    continue;
		if (utScan(HaveSpec, &HaveUnit) != 0) {
		    udadvise("%s: Don't recognize \"%s\"", me, HaveSpec);
		    if (ferror(stderr))
			goto failure;
		} else {
		    for (;;) {
			i	= GetSpec("You want: ", WantSpec, 
					  sizeof(WantSpec));
			if (i == -1)
			    goto failure;
			if (i == 0)
			    goto success;
			if (WantSpec[0] == 0) {
			    char	*s;

			    (void)utPrint(&HaveUnit, &s);
			    if (printf("    Definition: \"%s\"\n", s) < 0) {
				WriteError(me);
				goto failure;
			    }
			} else if (utScan(WantSpec, &WantUnit) != 0) {
			    udadvise("%s: Don't recognize \"%s\"", 
					me, WantSpec);
			    if (ferror(stderr))
				goto failure;
			    continue;
			} else {
			    i	= utConvert(&HaveUnit, &WantUnit, 
						&slope, &intercept);
			    if (i == UT_ECONVERT) {
				udadvise("%s: Units are incompatible", me);
				if (ferror(stderr))
				    goto failure;
			    } else if (i == UT_EINVALID) {
				udadvise("%s: A unit is corrupted", me);
				if (ferror(stderr))
				    goto failure;
			    } else {
				if (intercept == 0) {
				    if (printf("    <%s> = <%s>*%g\n", 
					       WantSpec, HaveSpec, slope)
					   < 0)  {
					WriteError(me);
					goto failure;
				    }
				    if (printf("    <%s> = <%s>/%g\n", 
					       WantSpec, HaveSpec, 1./slope)
					   < 0)  {
					WriteError(me);
					goto failure;
				    }
				} else {
				    if (printf("    <%s> = <%s>*%g %s %g\n", 
					       WantSpec, HaveSpec, slope,
					       intercept < 0
						    ? "-"
						    : "+",
					       ABS(intercept)) < 0) {
					WriteError(me);
					goto failure;
				    }
				    if (printf("    <%s> = <%s>/%g %s %g\n", 
					       WantSpec, HaveSpec, 1./slope,
					       intercept < 0
						    ? "-"
						    : "+",
					       ABS(intercept)) < 0) {
					WriteError(me);
					goto failure;
				    }
				}
			    }			/* successful conversion */
			}			/* "want" decoded */
			break;
		    }				/* "want" loop */
		}				/* "have" decoded */
	    }					/* "have" loop */
	}					/* units package initialized */
    }						/* udres package initialized */

    failure:
	status	= EXIT_FAILURE;
	goto exit;
    success:
	status	= EXIT_SUCCESS;
	goto exit;

    exit:
	utTerm();
	return status;
}
