

/*C*

________________________________________________________________

        pnm2biff
        $Id: pnm2biff.c,v 1.4 1997/01/02 13:45:20 svein Exp $
        Copyright 1994, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

static char *Id = "$Id: pnm2biff.c,v 1.4 1997/01/02 13:45:20 svein Exp $, Blab, UiO";

#include <pnm.h>
#include <xite/biff.h>
#include <xite/readarg.h>
#include <xite/message.h>

#define  BIFF_BLACK 0
#define  BIFF_WHITE 255



#ifndef FUNCPROTO
static IPIXTYP bitsToPixtyp(bits)
int bits;
#else /* FUNCPROTO */
static IPIXTYP bitsToPixtyp(int bits)
#endif /* FUNCPROTO */
{
  IPIXTYP pt;

  if       (bits <= 8) pt = Iu_byte_typ;
  else if (bits <= 16) pt = Iu_short_typ;
  else pt = -1;

  return(pt);

} /* bitsToPixtyp() */



/*P:pnm2biff*

________________________________________________________________

		pnm2biff
________________________________________________________________

Name:		pnm2biff - Portable Bit/Gray/Pixel Map to BIFF conversion

Syntax:		| pnm2biff [<option>...] <pnm-infile> <BIFF-outfile>

Description:    Read an image in one of the formats pbm (portable bitmap),
                pgm (portable graymap) or ppm (portable pixmap) from the file
		'pnm-file' (pnm: portable anymap).
                Produce a BIFF-image as output in the file 'BIFF-outfile'.

		If the pnm-image is a pbm-image, set white equal to 'hpv'
		(default 255) and black equal to 'lpv' (default 0).

		The pixeltype of the resulting BIFF image is determined
		by the maximum pixelvalue of the pnm image, according to
		this table
		| max pnm value in #bits         BIFF pixeltype
		|    8                           unsigned byte
                |   16                           unsigned short

		Larger pnm-values generate an error message.

Options:        &-title title, -t title
                Title of resulting BIFF-image. Default: pnm2biff

                &-lpv lpv
                If pnm image is bitmap: Low pixel value. Default: 0

                &-hpv hpv
                If pnm image is bitmap: High pixel value. Default: 255

See also:       biff2pnm(1), XITE(1), raw2biff(1)

Reference:      Documentation for the pbmplus or netpbm free software
                packages.

Author:		Svein Be, Blab, Ifi, UiO

Examples:       | pnm2biff monabinary.pnm monabinary.img

Id: 		$Id: pnm2biff.c,v 1.4 1997/01/02 13:45:20 svein Exp $
________________________________________________________________

*/

#ifdef MAIN

#ifndef FUNCPROTO
int main( argc, argv )
int argc;
char* argv[];
#else /* FUNCPROTO */
int main( int argc, char *argv[])
#endif /* FUNCPROTO */
{
  IMAGE iub = NULL;
  IUS_IMAGE ius = NULL;
  FILE* ifp;
  xel** pnm;
  xelval maxval;
  int rows, cols, xsize, ysize, format, x, y, lpv, hpv;
  int bitsPerSample;
  char *title, *args;
  IPIXTYP pt;

  InitMessage(&argc, argv, xite_app_std_usage_text(
  "Usage: %s [<option>...] <pnm-infile> <BIFF-outfile>\n\
     where <option> is chosen from\n\
     -t <title>   : Title of resulting BIFF-image.\n\
     -lpv <lpv>   : Low pixel-value of BIFF-image if pnm-image is pbm.\n\
     -hpv <hpv>   : High pixel-value of BIFF-image if pnm-image is pbm.\n"));

  Iset_message(1);		/* Warnings from BIFF-software */
  if (argc == 1) Usage(1, NULL);
  args = argvOptions(argc, argv);
  
  pnm_init(&argc, argv);
  
  title = read_switch(&argc, argv, "-t", 1, "pnm2biff");
  title = read_switch(&argc, argv, "-title", 1, title);
  lpv   = read_iswitch(&argc, argv, "-lpv", BIFF_BLACK);
  hpv   = read_iswitch(&argc, argv, "-hpv", BIFF_WHITE);
  
  if (argc != 3) Usage(2, "Illegal number of arguments.\n");
  
  ifp = pm_openr(argv[1]);
  pnm = pnm_readpnm(ifp, &cols, &rows, &maxval, &format);
  
  xsize = cols;
  ysize = rows;
  
  bitsPerSample = pm_maxvaltobits(maxval);
  pt = bitsToPixtyp(bitsPerSample);
  
  if (pt < 0) {
    Error(2, "Unknown pixeltype in pnm file.\n");
  }

  switch (PNM_FORMAT_TYPE(format)) {
  case (PPM_FORMAT) : {
    if (pt == Iu_byte_typ) {
      iub = Imake_image(3, title, pt, xsize, ysize);
      
      for (y=1; y<=ysize; y++) {
	for (x=1; x<=xsize; x++) {
	  iub[1][y][x] = PPM_GETR(pnm[y-1][x-1]);
	  iub[2][y][x] = PPM_GETG(pnm[y-1][x-1]);
	  iub[3][y][x] = PPM_GETB(pnm[y-1][x-1]);
	}
      }
    } else if (pt == Iu_short_typ) {
      ius = (IUS_IMAGE) Imake_image(3, title, pt, xsize, ysize);
      
      for (y=1; y<=ysize; y++) {
	for (x=1; x<=xsize; x++) {
	  ius[1][y][x] = PPM_GETR(pnm[y-1][x-1]);
	  ius[2][y][x] = PPM_GETG(pnm[y-1][x-1]);
	  ius[3][y][x] = PPM_GETB(pnm[y-1][x-1]);
	}
      }
    }
  } /* PPM_FORMAT */
    break;
    
  case (PGM_FORMAT) : {
    if (pt == Iu_byte_typ) {
      iub = Imake_image(1, title, pt, xsize, ysize);
      
      for (y=1; y<=ysize; y++) {
	for (x=1; x<=xsize; x++) {
	  iub[1][y][x] = PNM_GET1(pnm[y-1][x-1]);
	}
      }
    } else if (pt == Iu_short_typ) {
      ius = (IUS_IMAGE) Imake_image(1, title, pt, xsize, ysize);
      
      for (y=1; y<=ysize; y++) {
	for (x=1; x<=xsize; x++) {
	  ius[1][y][x] = PNM_GET1(pnm[y-1][x-1]);
	}
      }
    }
  } /* PGM_FORMAT */
    break;

  case (PBM_FORMAT) : {
    if (pt == Iu_byte_typ) {
      iub = Imake_image(1, title, pt, xsize, ysize);
      
      for (y=1; y<=ysize; y++) {
	for (x=1; x<=xsize; x++) {
	  if (PNM_GET1(pnm[y-1][x-1]) == PBM_BLACK)
	    iub[1][y][x] = lpv;
	  else
	    iub[1][y][x] = hpv;
	}
      }
    } else if (pt == Iu_short_typ) {
      ius = (IUS_IMAGE) Imake_image(1, title, pt, xsize, ysize);
      
      for (y=1; y<=ysize; y++) {
	for (x=1; x<=xsize; x++) {
	  if (PNM_GET1(pnm[y-1][x-1]) == PBM_BLACK)
	    ius[1][y][x] = lpv;
	  else
	    ius[1][y][x] = hpv;
	}
      }
    }
  } /* PBM_FORMAT */
    break;

  default: {
    Error(2, "Unknown PNM format.\n");
  }
    break;
  } /* switch */
  
  if (iub) {
    Ihistory(iub, argv[0], args);
    Iwrite_image(iub, argv[2]);
  } else if (ius) {
    Ihistory((IMAGE) ius, argv[0], args);
    Iwrite_image((IMAGE) ius, argv[2]);
  }
  
  return(0);
}

#endif /* MAIN */
