;;;
;;;
;;; zenirc-complete.el --- Nifty hack for nick/channel/command completion
;;; for Zen Internet Relay Chat client

;;; Copyright (C) 1993, 1994 Ben A. Mesander

;;; Author: Per Persson <pp@solace.mh.se>
;;; Maintainer: Ben Mesander <ben@gnu.ai.mit.edu>
;;; Keywords: extensions
;;; Created: 1994/05/07

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, you can either send email to this
;;; program's maintainer or write to: The Free Software Foundation,
;;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Code:

;; alists for remembering nicks, servers, channels, and commands.

(defvar zenirc-nick-alist '()
  "*Association list of nicknames known to the client.")

(defvar zenirc-server-alist '()
  "*Association list of servers know to the client.")

(defvar zenirc-channel-alist '()
  "*Association list of channel names known to the client.")

(defvar zenirc-command-alist '()
  "*Association list of commands known to the client.")

(setq zenirc-command-alist
      '(("/privmsg" . "") ("/nick" . "") ("/notice" . "") ("/away" . "")
	("/join" . "") ("/mode" . "") ("/quit" . "") ("/part" . "") 
	("/topic" . "") ("/invite" . "") ("/kick" . "") ("/ison" . "")
	("/squit" . "") ("/whois" . "") ("/who" . "") ("/whowas" . "") 
	("/list" . "") ("/names" . "") ("/kill" . "") ("/ping" . "") 
	("/userhost" . "") ("/trace" . "") ("/lusers" . "") ("/time" . "")
	("/oper" . "") ("/connect" . "") ("/version" . "") ("/stats" . "")
	("/links" . "") ("/admin" . "") ("/users" . "") ("/summon" . "")
	("/help" . "") ("/info" . "") ("/motd" . "") ("/rehash" . "")
	("/die" . "") ("/query" . "") ("/notify" . "")))

;; make the tab key try to complete words
(define-key zenirc-mode-map "\t" 'zenirc-complete-nick)

;; so it doesn't matter if you try to complete "Omn" or "omn"
;; should this be buffer local ?
(setq completion-ignore-case t)

;; use of zenirc-format-nickuserhost-hook for adding nicknames to a nick alist
(zenirc-add-hook 'zenirc-format-nickuserhost-hook 'zenirc-add-nick-alist)
(defun zenirc-add-nick-alist (nickuserhost)
  (if (string-match "!" nickuserhost)
      (let ((from (substring nickuserhost 0 (string-match "!" nickuserhost))))
	(if (not (try-completion (zenirc-extract-nick from)
				  zenirc-nick-alist))
	    (setq zenirc-nick-alist (cons (cons (zenirc-extract-nick from)
						"") zenirc-nick-alist))))
    (if (not (try-completion nickuserhost zenirc-server-alist))
	(setq zenirc-server-alist (cons (cons nickuserhost "") 
					zenirc-server-alist)))))

;; use of JOIN-hook for adding channels to a channel alist
(zenirc-add-hook 'zenirc-server-JOIN-hook 'zenirc-add-channel-alist)
(defun zenirc-add-channel-alist (proc parsedmsg)
  (if (and (string= (downcase zenirc-nick) 
		    (downcase (zenirc-extract-nick (aref parsedmsg 1))))
	   (not (try-completion (substring (aref parsedmsg 2) 1)
				zenirc-channel-alist)))
      (setq zenirc-channel-alist (cons (cons 
					(aref parsedmsg 2)
					"") zenirc-channel-alist))))

;; get server names from /whois replies
(zenirc-add-hook 'zenirc-server-312-hook 'zenirc-add-server-alist)
(defun zenirc-add-server-alist (proc parsedmsg)
  (if (not (try-completion (aref parsedmsg 4) zenirc-server-alist))
      (setq zenirc-server-alist (cons (cons (aref parsedmsg 4) "")
					    zenirc-server-alist))))

;; here we go, completions under way.
(defun zenirc-complete-nick () 
  (interactive)
  (if (not (zenirc-beginning-of-input-p))
      (progn 
	; set kill-ring to the word we wanna complete
	(setq from (point))
       	(if (search-backward " " (save-excursion 
				   (beginning-of-line) (point)) t)
	    (progn (forward-char)
		   (kill-forward-chars (- from (point))))
	  (beginning-of-line)
	  (kill-line))
	(cond
         ; actually do the completion.. 
	 ((null (setq completed-nick 
		      (if (string-match "/" (car kill-ring))
			  (try-completion (car kill-ring)
					  zenirc-command-alist)
			; channel names start with # or &
			(if (or (string-match "#" (car kill-ring))
				(string-match "&" (car kill-ring)))
			    (try-completion (car kill-ring)
					    zenirc-channel-alist)
			  (or (try-completion (car kill-ring)
					      zenirc-nick-alist)
			      (try-completion (car kill-ring)
					      zenirc-server-alist))))))
	  ; make a nice mini-buffer message
	  (message "No matches")))
	; if the word is the nick we wanted to complete
	(if (string= completed-nick t)
	    (insert (car kill-ring))
	  ; if no matches, insert the word again
	  (if (not completed-nick)
	      (insert (car kill-ring))
	    ; if there is multiple matches, show them in the mini-buffer and
	    ; insert the word again
	    (if (string= (downcase (car kill-ring)) 
			 (downcase completed-nick))
		(progn 
		  (message "%s" (all-completions 
				 (car kill-ring) (or zenirc-nick-alist 
						     zenirc-channel-alist)))
		  (insert (car kill-ring)))
	      ; insert the completed nick name
	      (insert completed-nick))))
        ; this is a lame fix for a bug, this complete code adds the word to the
        ; kill-ring contiously if you hit tab over and over again, this fixes
        ; that but should be done in another way. 
        ; 94-03-07 Changed it a bit so the code wont bug at least.. now
	; it works as it should, but not in the nicest way I guess.
	(setq kill-ring (delq (car kill-ring) kill-ring))
	(setq kill-ring (cons "" kill-ring)))))
