;; see file irchat-copyright.el for change log and copyright info
;; irchat.el splitted by kmk@tut.fi Sun Oct 14 18:58:10 EET 1990

(provide 'irchat-handle)

(defun irchat-handle-error-msg (prefix rest)
  (message "IRC error: %s" rest))

(defun irchat-handle-channel-msg (prefix rest)
  (if (string= prefix irchat-nickname)
      (progn
	(setq irchat-current-channel rest)
	(setq irchat-channel-indicator
	      (if (string= rest "0")
		  "No channel"
		(format "Channel %s" rest)))))
  (if (string= rest "0")
      (insert (format "%s%s has left this channel\n" 
		      irchat-change-prefix prefix))
    (if (not irchat-ignore-changes)
	(insert (format "%s%s has joined this channel\n" 
			irchat-change-prefix prefix)))
    (irchat-change-nick-of prefix prefix)))

(defun irchat-handle-linreply-msg (prefix rest)
  (if (string-match "^\\([^ ]+\\) +\\(.*\\)" rest)
      (progn
	(insert (matching-substring rest 1))
	(indent-to-column 30)
	(insert (matching-substring rest 2))
	(newline))
    (message "IRCHAT: Strange LINREPLY")))

(defun irchat-handle-482-msg (prefix rest)
  (message "IRCHAT: You are not a channel operator"))

(defun irchat-handle-msg-msg (prefix rest)
  (if (or (and prefix
	       (memq (intern prefix) irchat-kill-nickname)
	       (irchat-msg-from-ignored prefix rest))
	  (and (not prefix)
	       (string= "> " rest)))
      nil
    (if prefix 
	(let ((oma (get (intern prefix) 'chnl)))
	  (if oma
	      (while (string= "#" (substring (car oma) 0 1))
		(setq oma (cdr oma)))
	    (setq oma (list irchat-current-channel)))
	  (if (string= (car oma) irchat-current-channel)
	      (insert (format irchat-format-string2 prefix))
	    (insert 
	     (format irchat-format-string3 prefix (car oma))))
	  (insert " ")))
    (insert rest)
    (if (and (string-match "\007" rest) irchat-beep-on-bells)
	(progn
	  (if (not (get-buffer-window irchat-Dialogue-buffer))
	      (progn
		(beep t)
		(message "IRCHAT: %s is trying to get attention" prefix)))
	  (if (eq irchat-beep-on-bells 'always)
	      (beep t))))
    (newline)))

;;
;; This should work, mta Sun Nov 11 02:12:55 EET 1990
;;

(defun irchat-handle-namreply-msg (prefix rest)
  "Handle the NAMREPLY message.   If we are just polling the server,
don't display anything.  Check if someone we are waiting for has entered."
  (if (string-match "[=*] \\([^ ]*\\) \\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (users (matching-substring rest 2)))
					; we do not nuke @ here, it is info to users and should stay
					; mta Mon Jan 21 23:58:24 EET 1991
	(if irchat-polling
	    nil
	  (insert (format "%9s: %s" (if (string= chnl "*") "Priv" chnl)
			  (matching-substring rest 2)))
	  (newline))
	(irchat-scan-channels chnl)
	(irchat-scan-nicklist users)
;	(if (memq (intern chnl) irchat-current-channels))
	(irchat-update-thischannel chnl users))
    (message "IRCHAT: Strange NAMREPLY")))

;;
;;

(defun irchat-handle-nick-msg (prefix rest)
  (irchat-change-nick-of prefix rest)
  (put (intern rest) 'chnl (get (intern prefix) 'chnl))
  (put (intern prefix) 'chnl nil)
  (if (string= prefix irchat-nickname)
      (setq irchat-nickname rest))
  (insert (format "%s%s is now known as %s" irchat-change-prefix prefix rest))
  (newline))

;;; Kaizzu added removing of extraneous away-NOTICES 90-04-16 14:30:00.
;;; mta fixed irchat-shorten-kills 90-07-23

(defun irchat-handle-notice-msg (prefix rest)
  (if (and irchat-shorten-kills
	   (string-match 
	    "Notice[: -]*Received KILL message for \\([^.]*\\)\\. From \\([^ ]*\\) Path: \\([^ ]*\\) ?\\(.*\\)"
	    rest))
      (let ((killed (matching-substring rest 1))
	    (killer (matching-substring rest 2))
	    (reason (matching-substring rest 4))
	    (buf (current-buffer)))
	(set-buffer irchat-KILLS-buffer)
	(goto-char (point-max))
	(insert (format "%s\n" rest))
	(set-buffer buf)
	(insert (format "%s%s KILLed %s %s\n" irchat-notice-prefix 
			killer killed (if (= (length reason) 0)
					  "-No reason-"
					reason))))
    (if (or (not irchat-ignore-extra-notices)
	    (not prefix)
	    (not (string-match "as being away" rest)))
	(if prefix
	    (if (string-match "\\(.*\\)" rest)
		(irchat-ctl-a-notice prefix rest)
	      (irchat-handle-privmsg-msg prefix rest))
	  (progn
	    (string-match "^\\([^ ]*\\) :\\(.*\\)" rest)
	    (insert (matching-substring rest 2))
	    (newline))))))

(defun irchat-handle-ping-msg (prefix rest)
  (irchat-send "PONG yourself")
  (irchat-maybe-poll))

(defun irchat-handle-pong-msg (prefix rest)
  (setq irchat-polling
	(eq irchat-polling 'start))) ; figure this out

(defun irchat-handle-privmsg-msg (prefix rest)
  (if (and prefix
	   (memq (intern prefix) irchat-kill-nickname)
	   (irchat-msg-from-ignored prefix rest))
      nil
    (if (and (string-match "\007" rest) irchat-beep-on-bells)
	(beep t))
    (string-match "^\\([^ ]+\\) :\\(.*\\)" rest)
    (let ((chnl (matching-substring rest 1))
	  (temp (matching-substring rest 2))
	  (case-fold-search t))
;;; mta Tue Oct 15 16:49:45 EET 1991
;;; removed restrictions of CTCP answering
      (if (string-match "\\(.*\\)" temp)
	  (setq temp (irchat-ctl-a-msg prefix temp)))
      (if (not (string= temp ""))
	  (progn
	    (insert
	     (cond
	      ((string-equal (upcase chnl)
			     (upcase irchat-nickname)) ;; private message to me
	       (format irchat-format-string1 prefix))
	      ((string-equal (upcase chnl)
			     (upcase (or irchat-current-channel ""))) ;; to this channel
	       (if (irchat-user-on-this-channel prefix chnl)
		   (format irchat-format-string2 prefix)
		 (format irchat-format-string4 prefix)))
	      (t ;; channel we are joined (not current)
	       (if (irchat-user-on-this-channel prefix chnl) 
		   (format irchat-format-string3 prefix chnl)
		 (format irchat-format-string5 prefix chnl)))))
	    (insert " " temp)
	    (or (get-buffer-window (current-buffer))
		(not (string-equal (upcase chnl) (upcase irchat-nickname)))
		(message "IRCHAT: A private message has arrived from %s" 
			 prefix))
	    ;; only private messages to us get time-stamp
	    (if (and (string-equal "A" irchat-away-indicator) 
		     (string-equal (upcase chnl) (upcase irchat-nickname)))
		(insert (format " (%s)" (current-time-string))))
	    (newline))))))

(defun irchat-handle-wall-msg (prefix rest)
  "Handle the WALL message."
  (insert (format "*broadcast%s* %s" (if prefix (concat " from " prefix) "")
		  rest))
  (newline))

(defun irchat-handle-wallops-msg (prefix rest)
  "Handle the WALLOPS message."
  (if irchat-show-wallops
      (insert (format "*wallops%s* %s\n" 
		      (if prefix (concat " from " prefix) "") rest)))
  (let ((buf (current-buffer)))
    (set-buffer irchat-WALLOPS-buffer)
    (goto-char (point-max))
    (insert (format "*wallops%s* %s\n" 
		    (if prefix (concat " from " prefix) "") rest))
    (set-buffer buf)))

(defun irchat-handle-whoreply-msg (prefix rest)
  "Handle the WHOREPLY message.
Check if someone we are waiting for has entered."
  (if (string-match "^\\([-*#+0-9][^ ]*\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (nick (matching-substring rest 5))
	    (oper (matching-substring rest 6)))
	(insert (format "%3s %10s %9s <%s@%s>"
			oper ;; Kaizzu 06/03/90
			(if (string= chnl "*") "Priv" ; *WORK* needed
			  (if (string= chnl "0")
			      "Priv"
			    chnl))
			nick
			(matching-substring rest 2)
			(irchat-clean-hostname (matching-substring rest 3))))
	(indent-to-column 54 1)
	(insert (matching-substring rest 7))
	(newline))
    (message "IRCHAT: Strange WHOREPLY")))

(defun irchat-handle-quit-msg (prefix rest)
  "Handle the QUIT message."
  (if (not irchat-ignore-changes)
      (insert (format "%s%s has left IRC %s\n" irchat-change-prefix prefix
		      (if (= 0 (length rest))
			  ""
			(format "(%s)" rest)))))
  (irchat-change-nick-of prefix nil))

(defun irchat-handle-topic-msg (prefix rest)
  "Handle the TOPIC message."
  (if (string-match "\\([^ :]*\\)[: ]*\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (topic (matching-substring rest 2)))
	(if (not irchat-ignore-changes)
	    (progn
	      (if (string-equal chnl irchat-current-channel)
		  (insert (format "%sNew topic on this channel set by %s: %s"
				  irchat-change-prefix prefix topic))
		(insert (format "%sNew topic on channel %s set by %s: %s"
				irchat-change-prefix chnl prefix topic)))
	      (newline))))
    (message "IRCHAT: Strange TOPIC")))

(defun irchat-handle-mode-msg (prefix rest)
  "Handle the MODE message."
  (if (not irchat-ignore-changes)
      (let ((chnl " ")
	    (str ""))
	(if (or (and (string-match "\\([^ ]*\\) \\(.*\\)" rest)
		     (setq chnl (matching-substring rest 1)
			   str (matching-substring rest 2)
			   chnl (if (string-equal chnl irchat-current-channel)
				    " "
				  chnl)))
		(and (string-match " \\(.*\\)" rest) 
		     (setq str (matching-substring rest 1))))
	    (insert (format "%sNew mode%sset by %s: %s\n" 
			    irchat-change-prefix
			    (if (string= chnl " ")
				chnl
			      (concat " for " chnl " "))
			    prefix
			    str))
	  (message "IRCHAT: Strange MODE")))))

(defun irchat-handle-kick-msg (prefix rest)
  "Handle the KICK message."
  (if (string-match "^\\([^ ]*\\) \\([^ ]*\\)" rest)
      (let ((match1 (matching-substring rest 1))
	    (match2 (matching-substring rest 2)))
	(if (string= match2 irchat-nickname)
	  (progn
	    (insert (format "%sYou were kicked off channel %s by %s.\n"
			    irchat-change-prefix
			    match1
			    prefix))
	    (setq 
	     irchat-current-channels
	     (delq (intern irchat-current-channel) irchat-current-channels)
	     irchat-current-channel
	     (and (car irchat-current-channels)
		  (format "%s" (car irchat-current-channels)))
	     irchat-channel-indicator
	     (if irchat-current-channel
		 (format "Channel %s" irchat-current-channel)
	       "No channel"))
	    (irchat-remove-from-thischannel irchat-nickname 
					    match1))
	  (insert (format "%s%s has kicked %s out%s\n" irchat-change-prefix 
			  prefix
			  match2
			  (if (string= (or irchat-current-channel "")
				       match1)
			      ""
			    (format " from channel %s" 
				    match1))))))
    (message "IRCHAT: Strange KICK.")))

(defun irchat-handle-invite-msg (prefix rest)
  (if (string-match " \\([^ ]+\\)" rest)
      (let ((chnl (matching-substring rest 1)))
	(insert (format "*** %s invites you to channel %s\n" prefix chnl))
	(setq irchat-invited-channel chnl))
    (message "IRCHAT: Strange INVITE")))

(defun irchat-handle-kill-msg (prefix rest)
  (if (string-match "[^ ]+ +:\\(.*\\)" rest)
      (let ((path (matching-substring rest 1)))
	(insert (format "*** IRCHAT: You were killed by %s. Path: %s. RIP" prefix path))
	(newline))
    (message "IRCHAT: strange KILL"))
  (setq irchat-channel-indicator "No channel"))

(defun irchat-handle-join-msg (prefix rest) ; kmk, 14101990
  (if (string-match "\\([^ ]*\\)\ .*" rest)
      (setq rest (matching-substring rest 1))) ;; throw away the channel mode
  (if (string= prefix irchat-nickname)
      (progn
	(setq irchat-current-channel rest)
	(setq irchat-current-channels
	      (cons (intern irchat-current-channel) irchat-current-channels))
 	(setq irchat-channel-indicator
	      (format "Channel %s" rest)))
    (irchat-add-to-channel prefix rest))
  (if (not irchat-ignore-changes)
      (insert (format 
	       "%s%s (%s) has joined this channel%s\n" 
	       irchat-change-prefix prefix irchat-userathost
	       (if (string= (or irchat-current-channel "") rest) ""
		 (format " (%s)" rest)))))
  (irchat-change-nick-of prefix prefix))

(defun irchat-handle-part-msg (prefix rest) ; kmk, 14101990
  (if (string= prefix irchat-nickname)
      (setq irchat-current-channels
	    (delq (intern rest) irchat-current-channels)
	    irchat-current-channel
	    (and (car irchat-current-channels)
		 (format "%s" (car irchat-current-channels)))
	    irchat-channel-indicator
	    (if irchat-current-channel
		(format "Channel %s" irchat-current-channel)
	      "No channel")))
  (if (not irchat-ignore-changes)
      (insert (format 
	       "%s%s has left this channel%s\n"
	       irchat-change-prefix prefix
	       (if (string= (or irchat-current-channel "") rest) ""
		 (format " (%s)" rest)))))
  (irchat-remove-from-thischannel prefix rest)
  (irchat-change-nick-of prefix prefix))

;; The newer versions of ircd partly use numeric reply codes a'la SMTP
;; These functions provided by mta@tut.fi.  Some cosmetic changes necessary.
;; kmk@assari.tut.fi sorted these 90/06/21 while adding 2.5 ones. The
;; order is now the one in numeric.h.

(defun irchat-handle-401-msg (prefix rest) ;;; ERR_NOSUCHNICK
  (if (string-match "[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((name (matching-substring rest 1))
	    (error (matching-substring rest 2)))
	(message "IRCHAT: %s: %s" name error)
	(irchat-send "WHOWAS %s" name)
;;;	(beep)
	)
    (message "IRCHAT: Strange 401 reply")))

(defun irchat-handle-402-msg (prefix rest) ;;; ERR_NOSUCHSERVER
  (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((host (matching-substring rest 2))
	    (msg (matching-substring rest 3)))
	(message (format "IRCHAT: %s: %s" host msg)))
    (if (string-match "^\\([^ ]*\\) :\\([^(]*\\)(\\([^)]*\\))." rest)
	(let ((host (matching-substring rest 3))
	      (msg (matching-substring rest 2)))
	  (message (format "IRCHAT: %s: %s" host msg)))
      (message "OPER: Strange 402 message"))))

(defun irchat-handle-403-msg (prefix rest) ;;; ERR_NOSUCHCHANNEL
  (or (string-equal rest (format "%s :Channel not found" prefix))
      (message "IRCHAT: Erroneous channel name.")))

(defun irchat-handle-404-msg (prefix rest) ;;; ERR_CANNOTSENDTOCHAN
  (message "IRCHAT: cannot write to a restricted channel"))

(defun irchat-handle-406-msg (prefix rest) ;;; ERR_??? (NOSUCHUSERWAS...)
  (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((user (matching-substring rest 2))
	    (msg (matching-substring rest 3)))
	(message (format "IRCHAT: %s: %s" user msg)))
    (message "WHOWAS: Strange 406 message")))

(defun irchat-handle-411-msg (prefix rest) ;;; ERR_NORECIPIENT
  (message "IRCHAT: No recipient given"))

(defun irchat-handle-412-msg (prefix rest) ;;; ERR_NOTEXTTOSEND
  (message "IRCHAT: no text to send"))

(defun irchat-handle-421-msg (prefix rest) ;;; ERR_UNKNOWNCOMMAND
  (and prefix 
       (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\)" rest)
	   (let ((comm (matching-substring rest 2)))
	     (cond 
	      ((string= comm "PART") nil)
	      ((string= comm "JOIN") nil)
	      (t 
	       (progn
		 (insert (format "*** IRCHAT: Unknown command: %s" comm))
		 (newline)))))
	 (message "Strange 421 message"))))

(defun irchat-handle-431-msg (prefix rest) ;;; ERR_NONICKNAMEGIVEN
  (insert "*** IRCHAT: No nickname given")
  (newline))

(defun irchat-handle-432-msg (prefix rest) ;;; ERR_ERRONEUSNICKNAME
  (insert "*** IRCHAT: Erroneus nickname")
  (newline))

(defun irchat-handle-433-msg (prefix rest) ;;; ERR_NICKNAMEINUSE
  "Handle the 433 reply (nickname already in use)"
  (save-excursion
    (set-buffer irchat-Command-buffer)
    (beep)
    (setq irchat-nickname irchat-old-nickname)
    (let ((nick (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\) +:\\(.*\\)" rest)
		    (matching-substring rest 2)
		  (if (string-match "^ *\\([^ ]+\\) :.*" rest)
		      (matching-substring rest 1)
		    "UNKNOWN (Could not figure out, contact irchat developers)"))))
      (message "IRCHAT: Nickname %s already in use.  Choose a new one with %s."
	       nick
	       (substitute-command-keys "\\[irchat-Command-nickname]")))))

(defun irchat-handle-441-msg (prefix rest) ;;; ERR_USERNOTINCHANNEL
  (insert "*** IRCHAT: You have not joined any channel")
  (newline))

(defun irchat-handle-442-msg (prefix rest) ;;; ERR_NOTONCHANNEL
  (if (string-match "\\([^ ]+\\) +\\([^ ]+\\) +\\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((who (matching-substring rest 2))
	    (where (matching-substring rest 3))
	    (msg (matching-substring rest 4)))
	(insert 
	 (format "*** User %s is not here (%s) [%s].\n" who where msg)))
    (message "IRCHAT: Strange 442 reply.")))

(defun irchat-handle-451-msg (prefix rest) ;;; ERR_NOTREGISTERED
  (message "IRCHAT: You have not registered yet."))

(defun irchat-handle-461-msg (prefix rest) ;;; ERR_NEEDMOREPARAMS
  (if (string-match "^\\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((message (matching-substring rest 2)))
	(message (format "IRCHAT: %s" message)))
    (message (format
	      "IRCHAT: %s (ERR_NEEDMOREPARAMS, maybe oper before user.)"
	      rest))))

(defun irchat-handle-462-msg (prefix rest) ;;; ERR_ALREADYREGISTRED
  (message "IRCHAT: Already registered"))

(defun irchat-handle-463-msg (prefix rest) ;;; ERR_NOPERMFORHOST
  (message "IRCHAT: This IRC server can't talk to you. Goodbye."))

(defun irchat-handle-464-msg (prefix rest) ;;; ERR_PASSWDMISMATCH
  (message "IRCHAT: Bad password"))

(defun irchat-handle-465-msg (prefix rest) ;;; ERR_YOUREBANNEDCREEP
  (message "IRCHAT: You're banned from IRC. Sorry."))

(defun irchat-handle-466-msg (prefix rest) ;;; ERR_YOUWILLBEBANNED
  (insert (format "*** You will be banned from IRC within %s minutes" rest))
  (newline))

(defun irchat-handle-471-msg (prefix rest) ;;; ERR_CHANNELISFULL
  (insert "*** IRCHAT: Sorry, channel is full")
  (newline))

(defun irchat-handle-472-msg (prefix rest) ;;; ERR_UNKNOWNMODE
  (string-match "^\\([^ ]+\\) +:?\\(.*\\)" rest)
  (let ((msg (matching-substring rest 2)))
    (insert (format "*** %s" msg))
    (newline)))

(defun irchat-handle-473-msg (prefix rest) ;;; ERR_INVITEONLYCHAN
  (insert "That channel is invite only and you have not been invited")
  (newline))

(defun irchat-handle-474-msg (prefix rest) ;;; ERR_???
  (string-match "^[^ ]* \\([^ ]+\\) :\\(.*\\)" rest)
  (let ((chnl (matching-substring rest 1))
 	(msg (matching-substring rest 2)))
    (insert (format "*** IRCHAT: You're banned from channel %s: %s" chnl msg))
    (newline)))

(defun irchat-handle-481-msg (prefix rest) ;;; ERR_NOPRIVILEGES
  (string-match "^\\([^ ]+\\) +:\\(.*\\)" rest)
  (let ((msg (matching-substring rest 2)))
    (insert (format "*** IRCHAT: %s" msg))
    (newline)))

(defun irchat-handle-491-msg (prefix rest) ;;; ERR_NOOPERHOST
  (message "IRCHAT: You can't be OPER here. Sorry."))

(defun irchat-handle-301-msg (prefix rest) ;;; RPL_AWAY
  (if (string-match "^[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (iswhat (matching-substring rest 2)))
	(insert 
	 (format "*** %s is marked as being AWAY, but left the message:"
		 who))
	(newline)
	(insert iswhat))
    (insert "IRCHAT: Strange 301 reply"))
  (newline))

(defun irchat-handle-302-msg (prefix rest) ;;; RPL_????
  "Handle the 302 reply, USERHOST reply?"
  (while (string-match 
	  "^[^ ]* :[ ]*\\([^*=]+\\)\\([*]*\\)=\\([+-]\\)\\([^ ]+\\)" rest)
    (let ((nick (matching-substring rest 1))
	  (oper (matching-substring rest 2))
	  (away (matching-substring rest 3))
	  (who (matching-substring rest 4)))
      (insert (format "Nick %s is %s [%s, %s]\n"
		      nick who 
		      (concat 
		       (if (string= oper "")
			   "Not ")
		       "Operator")
		      (concat 
		       (if (string= away "+")
			   "Not ")
		       "AWAY")))
      (setq rest (concat " :" (substring rest (match-end 4) nil))))))

(defun irchat-handle-303-msg (prefix rest) ;;; RPL_????
  "Handle the 303 reply, ISON reply?"
  (if (string-match "[^ ]+ :\\(.*\\)" rest)
      (if (string= (matching-substring rest 1) "")
	  (insert "No one you requested is on now.\n")
	(insert (format "Following people(s) are on: %s\n"
			(matching-substring rest 1))))
    (insert "IRCHAT: Strange 303 reply\n")))

(defun irchat-handle-311-msg (prefix rest) ;;; RPL_WHOISUSER
  "Handle the 311 reply (from WHOIS)."
  (if (string-match "[^ ]+ \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((nick (matching-substring rest 1))
	    (username (matching-substring rest 2))
	    (machine (matching-substring rest 3))
	    (channel (matching-substring rest 4))
	    (realname (matching-substring rest 5)))
	(insert 
	 (format "%s is %s (%s) at %s"
		 nick
		 username
		 realname
		 machine)))
    (insert "IRCHAT: Strange 311 reply"))
  (newline))

(defun irchat-handle-312-msg (prefix rest) ;;; RPL_WHOISSERVER
  "Handle the 312 reply (from WHOIS)."
  (if (string-match "^[^ ]+ \\(\\([^ ]+\\) \\)?\\([^ ]+\\) :\\(.*\\)" rest)
      (let ((server (matching-substring rest 3))
	    (real (matching-substring rest 4)))
	(insert 
	 (format "on via server %s (%s)"
		 server
		 real)))
    (insert "IRCHAT: Strange 312 reply"))
  (newline))

(defun irchat-handle-313-msg (prefix rest) ;;; RPL_WHOISOPERATOR
  (if (string-match "^[^ ]+ \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (iswhat (matching-substring rest 2)))
	(insert 
	 (format "STATUS: %s"
		 iswhat)))
    (insert "IRCHAT: Strange 313 reply"))
  (newline))

(defun irchat-handle-316-msg (prefix rest) ;;; RPL_WHOISCHANOP
  "Handle 316 reply, oper status message."
  (if (string-match "^\\([^ ]+\\) :\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (iswhat (matching-substring rest 2)))
	(insert 
	 (format "STATUS: %s"
		 iswhat)))
    (if (string-match "^\\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
	(let ((who (matching-substring rest 2))
	      (iswhat (matching-substring rest 3)))
	  (insert 
	   (format "STATUS: %s"
		   iswhat)))
      (insert "IRCHAT: Strange 316 reply")))
  (newline))

(defun irchat-handle-319-msg (prefix rest) ;;; RPL_????
  "Handle the 319 reply (what channels user is on)."
  (if (string-match "^\\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((who (matching-substring rest 2))
	    (isonchannels (matching-substring rest 3)))
	(insert (format "channels: %s\n" isonchannels)))))

(defun irchat-handle-314-msg (prefix rest) ;;; RPL_WHOWASUSER
  "Handle the 314 reply (msa's WHOWAS)."
  (if (string-match "[^ ]+ \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((nick (matching-substring rest 1))
	    (username (matching-substring rest 2))
	    (machine (matching-substring rest 3))
	    (channel (matching-substring rest 4))
	    (realname (matching-substring rest 5)))
	(message "")
	(insert 
	 (format "%s [%s] was %s (%s) at %s"
		 nick
		 (if (string= channel "*") "Priv" channel)
		 username
		 realname
		 machine)))
    (message "IRCHAT: Strange 314 reply"))
  (newline))

(defun irchat-handle-315-msg (prefix rest) ;;; RPL_ENDOFWHO
  nil)

(defun irchat-handle-317-msg (prefix rest) ;;; RPL_WHOISIDLE
  "Handle the 317 reply."
  (if (string-match "^[^ ]+ [^ ]+ \\([0-9]*\\) :\\(.*\\)" rest)
      (insert (format "IDLE for %s\n" (irchat-convert-seconds 
				       (matching-substring rest 1))))
    (if (string-match "^[^ ]+ \\([0-9]*\\) :\\(.*\\)" rest)
	(insert (format "IDLE for %s\n" (irchat-convert-seconds 
					 (matching-substring rest 1))))
      (if (string-match ;;; maybe older 2.6 or 2.5 server?
	   "^\\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) +\\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)"
	   rest)
	  (let ((dofw (matching-substring rest 2))
		(month (matching-substring rest 3))
		(date (matching-substring rest 4))
		(time (matching-substring rest 5))
		(year (matching-substring rest 6)))
	    (insert (format "Last input received %s." time))
	    (newline))
	(message "IRCHAT: Strange 317 reply")))))

(defun irchat-handle-318-msg (prefix rest) ;;; RPL_ENDOFWHOIS
  "Handle the 318 reply (end of WHOIS)."
  nil)

(defun irchat-handle-321-msg (prefix rest) ;;; RPL_LISTSTART
  "Handle the 321 reply (first line from NAMES)."
  (insert
   (format "%-10s%6s  %s"
	   "Channel"
	   "Users"
	   "Topic"))
  (newline))

(defun irchat-handle-322-msg (prefix rest) ;;; RPL_LIST
  "Handle the 322 reply (from NAMES)."
  (if (string-match "^\\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 2))
	    (users (matching-substring rest 3))
	    (topic (matching-substring rest 4)))
	(if (or (string= irchat-channel-filter chnl)
		(string= irchat-channel-filter "")
		(and (string= irchat-channel-filter "0")
		     (string= chnl "*")))
	    (progn
	      (insert
	       (format "%-10s%6s  %s"
		       (if (string= chnl "*") "Priv"
			 chnl)
		       users
		       topic))
	      (newline))))
    (message "IRCHAT: Strange 322 reply")))

(defun irchat-handle-323-msg (prefix rest) ;;; RPL_LISTEND
  nil)

(defun irchat-handle-324-msg (prefix rest) ;;; RPL_CHANNELMODEIS
  "Handle the MODE message."
  (if (string-match "[^ ]* \\([^ ]*\\) \\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (str (matching-substring rest 2)))
	(insert (format "%sMode%sis %s\n" 
			irchat-change-prefix
			(if (string-equal chnl irchat-current-channel)
			    " "
			  (concat " for " chnl " "))
			str)))
    (message (format "IRCHAT: Strange 324 reply '%s'" rest))))

(defun irchat-handle-331-msg (prefix rest) ;;; RPL_NOTOPIC
  (insert "*** IRCHAT: No topic is set")
  (newline))

(defun irchat-handle-332-msg (prefix rest) ;;; RPL_TOPIC
  (if (string-match "[^ ] +:\\(.*\\)" rest)
      (let ((topic (matching-substring rest 1)))
	(insert (format "*** Topic: %s" topic))
	(newline))
    (message "IRCHAT: Strange 332 message")))

(defun irchat-handle-341-msg (prefix rest) ;;; RPL_INVITING
  (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\) +\\([-#0-9+][^ ]*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (nick (matching-substring rest 2))
	    (chnl (matching-substring rest 3)))
	(insert (format "*** %s: Inviting user %s to channel %s" who nick chnl))
	(newline))
    (message "Strange 341 message")))

(defun irchat-handle-351-msg (prefix rest) ;;; RPL_VERSION
  (if (string-match "[^ ]+ \\([^ ]+\\) \\([^ ]+\\)" rest)
      (let ((version (matching-substring rest 1))
	    (machine (matching-substring rest 2)))
	(insert 
	 (format "Machine %s is running IRC version %s"
		 prefix ;;; not machine, optional parameter and 
		        ;;; not clear whether it has a colon or not.
		 version))
	(newline))
    (message "IRCHAT: Strange 351 reply")))

(defun irchat-handle-361-msg (prefix rest) ;;; RPL_KILLDONE
  (if (string-match "[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((who (matching-substring rest 1))
	    (message (matching-substring rest 2)))
	(insert 
	 (format "You just KILLED %s. %s"
		 who
		 message))
	(newline))
    (message "IRCHAT: Strange 361 reply")))

(defun irchat-handle-365-msg (prefix rest) ;;; RPL_ENDOFLINKS
  nil)

(defun irchat-handle-366-msg (prefix rest) ;;; RPL_ENDOFNAMES
  nil)

(defun irchat-handle-371-msg (prefix rest) ;;; RPL_INFO
  (if (string-match "^\\([^ ]+\\) +:?\\(.*\\)" rest)
      (let ((msg (matching-substring rest 2)))
	(insert (format "*** %s" msg))
	(newline))
    (message "IRCHAT: Strange 371 message")))

(defun irchat-handle-372-msg (prefix rest) ;;; RPL_MOTD
  (string-match "^\\([^ ]+\\) +:?\\(.*\\)" rest)
  (let ((msg (matching-substring rest 2)))
    (insert (format "*** %s" msg))
    (newline)))

(defun irchat-handle-381-msg (prefix rest) ;;; RPL_YOUREOPER
  (if (string-match "^\\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((message (matching-substring rest 2)))
	(insert "OPER: " message)
	(newline))
    (message "IRCHAT: Strange 381 reply")))

(defun irchat-handle-382-msg (prefix rest) ;;; RPL_REHASHING
  (string-match "^\\([^ ]+\\) +:\\(.*\\)" rest)
  (let ((name (matching-substring rest 1))
	(msg (matching-substring rest 2)))
    (insert (format "*** %s: %s" name msg))
    (newline)))

(defun irchat-handle-391-msg (prefix rest) ;;; RPL_TIME
  (if (string-match "^\\([^ ]+\\) +\\(.*\\)" rest)
      (let ((time (matching-substring rest 2)))
	(insert (format "Time: %s" time))
	(newline))
    (message "IRCHAT: Strange 391 message")))

;;; End of numeric reply codes.

;;
;; updates users 'chnl (mta Sun Nov 11 02:13:26 EET 1990)
;; goes thru list of users updating all
;;

(defun irchat-update-thischannel (chnl origusers)
  "Update our copy of users on channel chnl."
  (let ((users origusers))
    (while (string-match "^\\([^ ]*\\) \\(.*\\)" users)
      (irchat-update-user chnl (matching-substring users 1))
      (setq users (matching-substring users 2)))
    (irchat-update-user chnl users)))

;;
;; updates one users chnl record
;;

(defun irchat-update-user (chnl user)
  "Set this users info to contain this cannel.
Handle @ before names."
  (if (not (string= "" user))
      (let (username)
	(if (string= (substring user 0 1) "@")
	    (setq username (intern (substring user 1 (length user))))
	  (setq username (intern user)))
	(put username 'chnl
	     (append (list chnl) (dell chnl (get username 'chnl)))))))

;;
;; returns list l1 with s1 removed
;;

(defun dell (s1 l1 &optional so_far)
  "Returns l1 without string s1."
  (if l1
      (if (string= (upcase s1) (upcase (car l1)))
	  (append so_far (cdr l1))
	(dell s1 (cdr l1) (append so_far (list (car l1)))))
    so_far))

;;
;; returns t if users chnl has this channel
;;

(defun irchat-user-on-this-channel (user chnl)
  "Returns t if user is in this channel"
  (not (= (length (get (intern user) 'chnl))
	  (length (dell chnl (get (intern user) 'chnl))))))

;;
;; adds this channel to users chnl
;;

(defun irchat-add-to-channel (user chnl)
  "Add users info to his chnl"
  (put (intern user) 'chnl 
       (append (list chnl) (dell chnl (get (intern user) 'chnl)))))

;;
;; removes this channel from users chnl
;;

(defun irchat-remove-from-thischannel (user chnl)
  "Remove users info from his chnl"
  (put (intern user) 'chnl 
       (dell chnl (get (intern user) 'chnl))))

;;
;; answer to client messages, no post processing
;;

(defun irchat-ctl-a-msg (from rest)
  "It's ctl-a request, act on it."
  (let* (left now right message rest-of-line)
    (if (string-match "^\\([^]*\\)\\([^]*\\)\\(.*\\)" rest)
	(progn
	  (setq left (matching-substring rest 1))
	  (setq now (matching-substring rest 2))
	  (setq right (matching-substring rest 3))
	  (setq rest (concat left right))
	  (if (string-match "^\\([^ ]*\\) \\(.*\\)" now)
	      (progn
		(setq message (downcase (matching-substring now 1)))
		(setq rest-of-line (matching-substring now 2)))
	    (if (string-match "^\\([^ ]*\\)" now)
		(progn
		  (setq message (downcase (matching-substring now 1)))
		  (setq rest-of-line nil))
	      (progn
		(setq message "errmsg")
		(setq rest-of-line "Couldn't figure out what was said."))))
	  (if (and (boundp (setq hook
				 (intern (concat "irchat-ctl-a-" message "-msg-hook"))))
		   (eval hook)
		   (eq (eval (list hook from rest-of-line)) t))
	      ;; If we have a hook, and it returns T, do nothing more
	      nil
	    ;; else call the handler
	    (if (fboundp (setq fun (intern
				    (concat "irchat-ctl-a-" message "-msg"))))
		(progn
		  (eval (list fun from rest-of-line))
		  (if (not irchat-freeze)
		      (irchat-scroll-if-visible
		       (get-buffer-window (current-buffer)))))
	      (progn
		(irchat-send "NOTICE %s :ERRMSG %s :%s"
			     from
			     (upcase message)
			     (format irchat-client-error-msg (upcase message)))
		(message (format "CLI-I-ENT %s query from %s."
				 (upcase message) from)))))
;;; what should we do ??? I suppose ignore the rest of CTCP
;;;	  (setq rest (irchat-ctl-a-msg from rest))))
	  ))
    rest))

(defun irchat-ctl-a-client-msg (from rest)
  (let* (message rest-of-line)
    (if rest
	(progn
	  (if (string-match "^\\([^ ]*\\) \\(.*\\)" rest)
	      (progn
		(setq message (downcase (matching-substring rest 1)))
		(setq rest-of-line (matching-substring rest 2)))
	    (if (string-match "^\\([^ ]*\\)" rest)
		(progn
		  (setq message (downcase (matching-substring rest 1)))
		  (setq rest-of-line nil))
	      (progn
		(setq message "errmsg")
		(setq rest-of-line "Couldn't figure out what was said."))))
	  (if (and (boundp (setq hook
				 (intern (concat "irchat-ctl-a-" message "-msg-hook"))))
		   (eval hook)
		   (eq (eval (list hook from rest-of-line)) t))
	      ;; If we have a hook, and it returns T, do nothing more
	      nil
	    ;; else call the handler
	    (if (fboundp (setq fun (intern
				    (concat "irchat-ctl-a-" message "-msg"))))
		(progn
		  (eval (list fun from rest-of-line))
		  (if (not irchat-freeze)
		      (irchat-scroll-if-visible
		       (get-buffer-window (current-buffer)))))
	      (message (format 
			"IRCHAT: Unknown CLIENT message from %s \"%s\""
			from (upcase message))))
	    )))))	      


(defun irchat-ctl-a-version-msg (from rest)
  (irchat-send 
   (format 
    "NOTICE %s :VERSION %s GNU-Emacs :%s for GNU Emacs"
    from
    irchat-version irchat-version
    ))
  (message (format "CLI-I-ENT VERSION query from %s."
		   from)))

(defun irchat-ctl-a-userinfo-msg (from rest)
  (irchat-send "NOTICE %s :USERINFO :%s"
	       from
	       irchat-client-userinfo)
  (message (format "CLI-I-ENT USERINFO query from %s." from)))


(defun irchat-ctl-a-clientinfo-msg (from rest)
  (irchat-send 
   (format 
    "NOTICE %s :CLIENTINFO :VERSION USERINFO CLIENTINFO HELP ERRMSG"
    from
    ))
  (message (format "CLI-I-ENT CLIENTINFO query from %s." from)))

(defun irchat-ctl-a-help-msg (from rest)
  (irchat-send 
   (format "NOTICE %s :HELP :VERSION gives version of this client"
	   from
	   ))
  (irchat-send 
   (format "NOTICE %s :HELP :USERINFO gives user supplied info (if any)"
	   from
	   ))
  (irchat-send 
   (format "NOTICE %s :HELP :CLIENTINFO gives commands this client knows"
	   from
	   ))
  (irchat-send 
   (format "NOTICE %s :HELP :HELP gives this help message"
	   from
	   ))
  (irchat-send 
   (format "NOTICE %s :HELP :ERRMSG tells you your command was not valid"
	   from
	   ))
  (message (format "CLI-I-ENT HELP query from %s." from)))

(defun irchat-ctl-a-comment-msg (from rest)  
  )

(defun irchat-ctl-a-xyzzy-msg (from rest)
  (irchat-send "NOTICE %s :Nothing happens.(xyzzy inactive)" from)
  (message (format "CLI-I-ENT XYZZY query from %s." from)))

;;
;; read CLIENT messages from notice, no postprocessing done
;;

(defun irchat-ctl-a-notice (prefix rest)
  "Ctl-a notice."
  (let* (message rest-of-line)
    (if (string-match "\\([^ ]*\\) \\(.*\\)" rest)
	(progn
	  (setq message (downcase (matching-substring rest 1)))
	  (setq rest-of-line (matching-substring rest 2)))
      (if (string-match "\\([^ ]*\\)" rest)
	  (progn
	    (setq message (downcase (matching-substring rest 1)))
	    (setq rest-of-line nil))
	(progn
	  (setq message "errmsg")
	  (setq rest-of-line "Couldn't figure out what was said."))))
    (if (and (boundp (setq hook
			   (intern (concat "irchat-ctl-a-" message "-notice-hook"))))
	     (eval hook)
	     (eq (eval (list hook prefix rest-of-line)) t))
	;; If we have a hook, and it returns T, do nothing more
	nil
      ;; else call the handler
      (if (fboundp (setq fun (intern
			      (concat "irchat-ctl-a-" message "-notice"))))
	  (progn
	    (eval (list fun prefix rest-of-line))
	    (if (not irchat-freeze)
		(irchat-scroll-if-visible
		 (get-buffer-window (current-buffer)))))
	(message (format 
		  "IRCHAT: Unknown ctl-a notice \":%s %s %s\"" 
		  prefix (upcase message) rest-of-line)))
      )))


(defun irchat-ctl-a-file-notice (prefix rest)
  (if irchat-file-accept
      (let* (message file-name rest-of-line)
	(string-match "^\\([^ ]*\\) \\([^ ]*\\) :\\(.*\\)" rest)
	(setq message (downcase (matching-substring rest 1)))
	(setq file-name (matching-substring rest 2))
	(setq rest-of-line (matching-substring rest 3))
	(if (and (boundp 
		  (setq hook
			(intern (concat "irchat-file-" message "-hook"))))
		 (eval hook)
		 (eq (eval (list hook prefix file-name rest-of-line)) t))
	    ;; If we have a hook, and it returns T, do nothing more
	    nil
	  ;; else call the handler
	  (if (fboundp (setq fun (intern
				  (concat "irchat-file-" message))))
	      (progn
		(eval (list fun prefix file-name rest-of-line))
		(if (not irchat-freeze)
		    (irchat-scroll-if-visible
		     (get-buffer-window (current-buffer)))))
	    (message (format 
		      "IRCHAT: Unknown FILE message \":%s %s %s %s\""
		      prefix (upcase message) file-name rest-of-line)))
	  ))
    (message (format
	      "FILE: %s sending, set irchat-file-accept to t and ask to resend"
	      prefix))))




(defun irchat-file-start (prefix name data)
  (save-excursion
    (set-buffer (get-buffer-create (format "*IRC R_FILE_%s*" name)))
    (delete-region (point-min) (point-max))
    (insert data)
    ))

(defun irchat-file-cont (prefix name data)
  (save-excursion
    (set-buffer (get-buffer-create (format "*IRC R_FILE_%s*" name)))
    (goto-char (point-max))
    (insert data)
    ))

(defun irchat-file-end (prefix name data)
  (save-excursion
    (set-buffer (get-buffer-create (format "*IRC R_FILE_%s*" name)))
    (goto-char (point-max))
    (insert data)
    (let (str)
      (setq str (buffer-string))
      (delete-region (point-min) (point-max))
      (insert (irchat-quote-decode str)))
    (goto-char (point-min))
    (if (and irchat-file-confirm-save
	     (not (y-or-n-p "Save file?")))
	nil
      (progn
	(if (not (file-exists-p "~/.irchat"))
	    (shell-command (format "mkdir %s"
				   (expand-file-name ".irchat" "$HOME"))))
	(write-region (point-min) (point-max) (expand-file-name 
					       (file-name-nondirectory
						(format "%s(%s)" name prefix))
					       "~/.irchat"))
	(kill-buffer (get-buffer-create (format "*IRC R_FILE_%s*" name)))))
    ))


(defun irchat-ctl-a-client-notice (prefix rest)
  (let* (message rest-of-line)
    (if (string-match "^\\([^ ]*\\) \\(.*\\)" rest)
	(progn
	  (setq message (downcase (matching-substring rest 1)))
	  (setq rest-of-line (matching-substring rest 2)))
      (if (string-match "^\\([^ ]*\\)" rest)
	  (progn
	    (setq message (downcase (matching-substring rest 1)))
	    (setq rest-of-line nil))
	(progn
	  (setq message "errmsg")
	  (setq rest-of-line "Couldn't figure out what was said."))))
    (if (and (boundp (setq hook
			   (intern (concat "irchat-client-" message "-notice-hook"))))
	     (eval hook)
	     (eq (eval (list hook prefix rest-of-line)) t))
	;; If we have a hook, and it returns T, do nothing more
	nil
      ;; else call the handler
      (if (fboundp (setq fun (intern
			      (concat "irchat-client-" message "-notice"))))
	  (progn
	    (eval (list fun prefix rest-of-line))
	    (if (not irchat-freeze)
		(irchat-scroll-if-visible
		 (get-buffer-window (current-buffer)))))
	(message (format 
		  "IRCHAT: Unknown CLIENT notice \":%s %s %s %s\""
		  prefix (upcase message) rest-of-line)))
      )))

(defun irchat-client-version-notice (prefix rest)  
  (if rest
      (if (string-match "^\\([^:]*\\):\\(.*\\)" rest)
	  (insert (format irchat-client-message prefix 
			  (matching-substring rest 1)))
	(insert (format irchat-client-message prefix rest)))
    (message (format "Empty CLI-I-ENT version notice from \"%s\"." prefix))))



(defun irchat-client-clientinfo-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-client-userinfo-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-client-help-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-client-errmsg-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-client-comment-notice (from rest)  
  )

;;
;; same functions as above, but with plain notices i.e. no CLIENT in front of it
;;
(defun irchat-ctl-a-version-notice (prefix rest)  
  (if rest
      (if (string-match "^\\([^:]*\\):\\(.*\\)" rest)
	  (insert (format irchat-client-message prefix 
			  (matching-substring rest 1)))
	(if (string-match "^\\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\) \\(.*\\)" rest)
	    (insert (format irchat-client-message prefix
			    (format "%s %s for %s: %s" 
				    (matching-substring rest 1)
				    (matching-substring rest 2)
				    (matching-substring rest 3)
				    (matching-substring rest 4))))
	  (insert (format irchat-client-message prefix rest))))
    (message (format "Empty CLI-I-ENT version notice from \"%s\"." prefix))))



(defun irchat-ctl-a-clientinfo-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-ctl-a-userinfo-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-ctl-a-help-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-ctl-a-errmsg-notice (prefix rest)  
  (insert (format irchat-client-message prefix rest)))

(defun irchat-ctl-a-comment-notice (from rest)  
  )

;;
;; format string for both above series
;;
(defvar irchat-client-message "CLIENT@%s: %s\n" 
  "*Message in which info of other clients is displayed.")

;;
;; decode and encode of binary data
;;
(defun irchat-quote-decode (string-to-decode)
  (interactive)
  (save-excursion
    (set-buffer (get-buffer-create "*IRC DECODE*"))
    (delete-region (point-min) (point-max))
    (insert string-to-decode)
    (goto-char (point-min))
    (replace-string "\\\\" "\\")
    (goto-char (point-min))
    (replace-string "\\a" "")
    (goto-char (point-min))
    (replace-string "\\n" "\n")
    (goto-char (point-min))
    (replace-string "\\r" "\r")
    (setq string-to-decode (buffer-substring (point-min) (point-max)))
    ;;    (kill-buffer (get-buffer-create "*IRC DECODE*"))
    string-to-decode))

(defun irchat-quote-encode (string)
  (interactive)
  (save-excursion
    (set-buffer (get-buffer-create "*IRC ENCODE*"))
    (delete-region (point-min) (point-max))
    (insert string)
    (goto-char (point-min))
    (while (search-forward "\\" nil 1)
      (insert "\\"))
    (goto-char (point-min))
    (while (search-forward "" nil 1)
      (delete-char -1)
      (insert "\\a"))
    (goto-char (point-min))
    (while (search-forward " " nil 1)
      (delete-char -1)
      (insert "\\0"))
    (goto-char (point-min))
    (while (search-forward "\n" nil 1)
      (delete-char -1)
      (insert "\\n"))
    (goto-char (point-min))
    (while (search-forward "\r" nil 1)
      (delete-char -1)
      (insert "\\r"))
    (setq string (buffer-substring (point-min) (point-max)))
    ;;    (kill-buffer (get-buffer-create "*IRC ENCODE*"))
    string))

(defun irchat-handle-364-msg (prefix rest)
  (if (string-match "^\\([^ ]+\\) +\\([^ ]*\\) +:\\(.*\\)" rest)
      (progn
	(insert (matching-substring rest 2))
	(indent-to-column 30)
	(insert (matching-substring rest 3))
	(newline))
    (message "IRCHAT: Strange 364 message")))

(defun irchat-convert-seconds (time)
  "Convert seconds to printable string."
  (let* ((seconds (string-to-int time))
	 (minutes (/ seconds 60))
	 (seconds (if minutes (% seconds 60) seconds))
	 (hours (/ minutes 60))
	 (minutes (if hours (% minutes 60) minutes))
	 (days (/ hours 24))
	 (hours (if days (% hours 24) hours))
	 (ds (and (/= 0 days)
		  (format "%d day%s, " days
			  (if (> days 1) "s" ""))))
	 (hs (and (/= 0 hours)
		  (format "%d hour%s, " hours
			  (if (> hours 1) "s" ""))))
	 (ms (and (/= 0 minutes)
		  (format "%d minute%s " minutes
			  (if (> minutes 1) "s" ""))))
	 (ss (format "%d seconds" seconds)))
    (concat ds hs ms (if seconds ss ""))))

(defun irchat-msg-from-ignored (prefix rest)
  (save-excursion
    (let ((buf (current-buffer)))
      (set-buffer irchat-IGNORED-buffer)
      (goto-char (point-max))
      (insert (format "%s::%s\n" prefix rest))
;;;      (message (format "%s::%s" prefix rest))
      (set-buffer buf)
      t)))

;;; New replies for 2.7 go here

(defun irchat-handle-353-msg (prefix rest)
  "Handle the 353 (NAMREPLY) message.   If we are just polling the server,
don't display anything.  Check if someone we are waiting for has entered."
  (if (string-match "[^ =*@]?[=*@] \\([^ ]*\\) :\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (users (matching-substring rest 2)))
	(if irchat-polling
	    nil
	  (insert (format "%9s: %s" (if (string= chnl "*") "Priv" chnl)
			  users))
	  (newline))
	(irchat-scan-channels chnl)
	(let ((max-lisp-eval-depth 1000)) ;;; this will recurse
	  (irchat-scan-nicklist users))
	(irchat-update-thischannel chnl users))
    (if (string-match "[^ ] [=*] \\([^ ]*\\) \\(.*\\)" rest)
	(message "You are using an old buggy 2.7 server, you lose.")
      (message "IRCHAT: Strange 353 message"))))

(defun irchat-handle-352-msg (prefix rest)
  "Handle the WHOREPLY message (352).
Check if someone we are waiting for has entered."
  (if (string-match "\\([^ ]*\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) \\([^ ]+\\) :[0-9]* ?\\(.*\\)" rest)
      (let ((chnl (matching-substring rest 1))
	    (nick (matching-substring rest 5))
	    (oper (matching-substring rest 6)))
	(insert (format "%3s %10s %9s <%s@%s>"
			oper ;; Kaizzu 06/03/90
			(if (string= chnl "*") "Priv" ; *WORK* needed
			  (if (string= chnl "0")
			      "Priv"
			    chnl))
			nick
			(matching-substring rest 2)
			(irchat-clean-hostname (matching-substring rest 3))))
	(indent-to-column 54 1)
	(insert (matching-substring rest 7))
	(newline))
    (message "IRCHAT: Strange 352 message")))

(defun irchat-handle-203-msg (prefix rest)
  (if (string-match "\\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\)[ :]+\\(.*\\)" rest)
      (let ((status (matching-substring rest 2))
	    (class (matching-substring rest 3))
	    (who (matching-substring rest 4)))
	(insert (format "*** %s Class[%s] ==> %s"
			status class who))
	(newline))
    (message "IRCHAT: Strange 203 message")))

(defun irchat-handle-204-msg (prefix rest)
  (if (string-match "\\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\)[ :]+\\(.*\\)" rest)
      (let ((status (matching-substring rest 2))
	    (class (matching-substring rest 3))
	    (who (matching-substring rest 4)))
	(insert (format "*** %s Class[%s] ==> %s"
			status class who))
	(newline))
  (message "IRCHAT: Strange 204 message")))

;;;	static char Lformat[]  = "NOTICE %s :%-15.15s%5u%7u%10u%7u%10u %s";

(defun irchat-handle-211-msg (prefix rest)
  (if (string-match "\\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\)[ :]+\\(.*\\)" rest)
      (let ((link (matching-substring rest 2))
	    (sendq (matching-substring rest 3))
	    (sendm (matching-substring rest 4))
	    (sendb (matching-substring rest 5))
	    (rcvem (matching-substring rest 6))
	    (rcveb (matching-substring rest 7))
	    (open (matching-substring rest 8)))
	(insert link)
	(indent-to-column 35)
	(insert (format "%5s%7s%10s%7s%10s %s"
			sendq sendm sendb rcvem rcveb open))
	(newline))
    (message "IRCHAT: Strance 211 message")))

(defun irchat-handle-219-msg (prefix rest)
  nil)

(defun irchat-handle-213-msg (prefix rest)
  (if (string-match "[^ ]* \\(.\\) \\([^ ]*\\) \\(.\\) \\([^ ]*\\) \\([0-9]*\\) \\([0-9]*\\)" rest)
      (let ((cn (matching-substring rest 1))
	    (canon (matching-substring rest 2))
	    (pass (matching-substring rest 3))
	    (name (matching-substring rest 4))
	    (port (matching-substring rest 5))
	    (hmmm (matching-substring rest 6)))
	(insert (format "%s:%s:%s:%s:%s:%s"
			cn canon pass name port hmmm))
	(newline))
    (message "IRCHAT: Strange 213 message")))


(defun irchat-handle-214-msg (prefix rest)
  (if (string-match "[^ ]* \\(.\\) \\([^ ]*\\) \\(.\\) \\([^ ]*\\) \\([0-9]*\\) \\([0-9]*\\)" rest)
      (let ((cn (matching-substring rest 1))
	    (canon (matching-substring rest 2))
	    (pass (matching-substring rest 3))
	    (name (matching-substring rest 4))
	    (port (matching-substring rest 5))
	    (hmmm (matching-substring rest 6)))
	(insert (format "%s:%s:%s:%s:%s:%s"
			cn canon pass name port hmmm))
	(newline))
    (message "IRCHAT: Strange 214 message")))

(defun irchat-handle-212-msg (prefix rest)
  (if (string-match "[^ ]* \\([^ ]*\\) \\([0-9]*\\)" rest)
      (let ((cmd (matching-substring rest 1))
	    (times (matching-substring rest 2)))
	(insert (format "%s has been used %s times after startup"
			cmd times))
	(newline))
    (message "IRCHAT: Strange 212 message")))

;;; k2 I * * * 0 0
(defun irchat-handle-215-msg (prefix rest)
  (if (string-match "[^ ]* I \\([^ ]*\\) \\(.\\) \\([^ ]*\\) 0 0" rest)
      (let ((domain (matching-substring rest 1))
	    (passwd (matching-substring rest 2))
	    (redomain (matching-substring rest 3)))
	(insert (format "*** I:%s:%s:%s:0:0"
			domain passwd redomain))
	(newline))
    (message "IRCHAT: Strange 215 message")))
	  

;;; k2 Q <NULL> * eris.berkeley.edu 0 -1
(defun irchat-handle-217-msg (prefix rest)
  (if (string-match "[^ ]* Q \\([^ ]*\\) \\(.\\) \\([^ ]*\\) \\(.*\\)" rest)
      (let ((reason (matching-substring rest 1))
	    (star (matching-substring rest 2))
	    (host (matching-substring rest 3))
	    (stuff (matching-substring rest 4)))
	(insert (format "*** Q:%s:%s:%s:%s"
			reason star host stuff))
	(newline))
    (message "IRCHAT: Strange 217 message")))

;;; k2 Y 1 90 300 10
(defun irchat-handle-218-msg (prefix rest)
  (if (string-match "[^ ]* Y \\([0-9]*\\) \\([0-9]*\\) \\([0-9]*\\) \\([0-9]*\\)" rest)
      (let ((class (matching-substring rest 1))
	    (pingfreq (matching-substring rest 2))
	    (confreq (matching-substring rest 3))
	    (maxlinks (matching-substring rest 4)))
	(insert (format "*** Class %s: PingFreq %s, ConFreq %s, MaxLinks %s"
			class pingfreq confreq maxlinks))
	(newline))
    (message "IRCHAT: Strange 218 message")))
    
;;; k2 K *.hut.fi * tsh 0 -1
(defun irchat-handle-216-msg (prefix rest)
  (if (string-match "[^ ]* K \\([^ ]*\\) \\(.\\) \\([^ ]*\\) 0 -1" rest)
      (let ((host (matching-substring rest 1))
	    (pass (matching-substring rest 2))
	    (user (matching-substring rest 3)))
	(insert (format "*** K:%s:%s:%s" host pass user))
	(newline))
    (message "IRCHAT: Strange 216 message")))

(defun irchat-handle-204-msg (prefix rest)
  (if (string-match "[^ ]* \\([^ ]*\\) \\([0-9]*\\)[ :]*\\(.*\\)" rest)
      (let ((kind (matching-substring rest 1))
	    (hops (matching-substring rest 2))
	    (where (matching-substring rest 3)))
	(insert (format "*** %s Class[%s] ==> %s"
			kind hops where))
	(newline))
    (message "IRCHAT: Strange 204 message")))

(defun irchat-handle-205-msg (prefix rest)
  (if (string-match "[^ ]* \\([^ ]*\\) \\([0-9]*\\)[ :]*\\(.*\\)" rest)
      (let ((kind (matching-substring rest 1))
	    (hops (matching-substring rest 2))
	    (where (matching-substring rest 3)))
	(insert (format "*** %s Class[%s] ==> %s"
			kind hops where))
	(newline))
    (message "IRCHAT: Strange 205 message")))

(defun irchat-handle-206-msg (prefix rest)
  (if (string-match "Serv \\([^ ]*\\) \\(.*\\)" rest)
      (let ((class (matching-substring rest 1))
	    (pars (matching-substring rest 2)))
	(if (string-match "^[ :]*\\(.*\\)" pars)
	    (insert (format "*** Serv %s (%s) ==> %s"
			    prefix class
			    (matching-substring pars 1)))
	  (if (string-match 
	       "[ :]*\\([0-9]*\\)*C \\([0-9]*\\)*S[ :]*\\(.*\\)"
	       pars)
	      (insert (format
		       "*** Serv %s (%s) ==> %s (%sC, %sS)"
		       prefix class
		       (matching-substring pars 3)
		       (matching-substring pars 1)
		       (matching-substring pars 2)))
	    (insert (format "*** Serv %s (%s) ==> %s"
			    prefix class pars))))
	(newline))
    (message "IRCHAT: Strange 206 message")))

(defun irchat-handle-209-msg (prefix rest)
  (if (string-match "[^ ]* Class \\([0-9]*\\) \\([0-9]*\\)" rest)
      (let ((class (matching-substring rest 1))
	    (entries (matching-substring rest 2)))
	(insert (format "*** Class %s Entries linked: %s"
			class entries))
	(newline))
    (message "IRCHAT: Strange 209 message")))

;;; :fuug.fi 367 k2 #ban *.edu!*@* k2
;;; :fuug.fi 368 k2 :End of Channel Ban List

(defun irchat-handle-367-msg (prefix rest)
  (if (string-match "[^ ]* \\([^ ]*\\) \\([^ ]*\\)" rest)
      ; no banner anymore? jtp Wed Jan 15 13:56:11 1992
      (let ((chnl (matching-substring rest 1))
	    (regexp (matching-substring rest 2)))
	(insert (format "*** %s has been banned on %s"
			regexp chnl))
	(newline))
    (message "IRCHAT: Strange 367 message")))

(defun irchat-handle-368-msg (prefix rest)
  nil)

;;; What is 369? End of WHOWAS?
(defun irchat-handle-369-msg (prefix rest)
  nil)

(defun irchat-handle-200-msg (prefix rest) ;;; RPL_TRACELINK
  (if (string-match "Link \\([^ ]*\\)[ :]*\\(.*\\)" rest)
      (let ((version (matching-substring rest 1))
	    (dest (matching-substring rest 2)))
	(insert (format "*** Link %s (%s) ==> %s"
			prefix version dest))
	(newline))
    (message "IRCHAT: Strange 200 message")))

;;; :irc.fuug.fi 201 nAm Try. 0 :cs.hut.fi
(defun irchat-handle-201-msg (prefix rest)
  (if (string-match "[^ ]* [^ ]* \\([0-9]*\\)[ :]*\\(.*\\)" rest)
      (let ((class (matching-substring rest 1))
	    (server (matching-substring rest 2)))
	(insert (format "*** Trying to connect to %s (class: %s)"
			server class))
	(newline))
    (message "IRCHAT: Strange 201 message")))

;;; :eff.org 202 nAm H.S. 0 :irc.ibmpcug.co.uk[rachel.ibmpcug.co.uk]
(defun irchat-handle-202-msg (prefix rest)
  (if (string-match "[^ ]* [^ ]* \\([0-9]*\\)[ :]*\\(.*\\)" rest)
      (let ((class (matching-substring rest 1))
	    (server (matching-substring rest 2)))
	(insert (format "*** Handshaking with %s (class: %s)"
			server class))
	(newline))
    (message "IRCHAT: Strange 202 message")))
