case $CONFIG in
'')	 if test -r ../config.sh
	 then 
	    . ../config.sh ;
	 else 
	    spitshell=cat
	    package=IRC
	 fi
	 ;;
esac

echo "Extracting $package/ircd/version.c..."

if test -r version.c
then
   generation=`sed -n 's/^char \*generation = \"\(.*\)\";/\1/p' < version.c`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi


generation=`expr $generation + 1`

creation=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/*
 *   IRC - Internet Relay Chat, ircd/version.c
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "struct.h"
#include "patchlevel.h"

char *generation = "$generation";
char *creation = "$creation";
char *version = PATCHLEVEL;

char *infotext[] =
    {
	"$package --",
	"Based on the original code written by Jarkko Oikarinen",
	"Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
	"",
	"This program is free software; you can redistribute it and/or",
	"modify it under the terms of the GNU General Public License as",
	"published by the Free Software Foundation; either version 1, or",
	"(at your option) any later version.",
	"",
	"The following persons have made many changes and enhancements to the",
	"code and may know how IRC really works if you have questions about it:",
	"",
	"WiZ          Jarkko Oikarinen         jto@tolsun.oulu.fi",
	"Msa          Markku Savela            Markku.Savela@vtt.fi",
	"Misha        Mike Bolotski            mikeb@salmon.ee.ubc.ca",
	"Chelsea      Chelsea Ashley Dyerman   casie@earth.CChem.Berkeley.EDU",
	"Wumpus       Greg Lindahl             gl8f@astsun.astro.virginia.edu",
	"Armin        Armin Gruner             Armin.Gruner@Informatik.TU-Muenchen.de",
	"Avalon       Darren Reed              avalon@coombs.anu.edu.au",
	"",
	"Those who helped in prior versions and continue to be helpful:",
	"",
	"             Markku Jarvinen          mta@tut.fi",
	"Kim          Kimmo Suominen           kim@lut.fi",
	"             Jeff Trim                jtrim@orion.cair.du.edu",
	"Vijay        Vijay Subramaniam        vijay@lll-winken.llnl.gov",
	"poptart      Karl Kleinpaste          karl.kleinpaste@osc.edu",
	"Wisner       Bill Wisner              wisner@hayes.fai.alaska.edu",
	"             Tom Davis                conslt16@zeus.unl.edu",
	"",
	"Various modifications, bugreports, cleanups by:",
	"",
	"Hugo         Hugo Calendar            hugo@ucscb.ucsc.edu",
	"Thumper      Bo Adler                 thumper@betwixt.ugcs.caltech.edu",
	"BigCheese    Michael Sandrof          ms5n+@andrew.cmu.edu",
	"jsol         Jon Solomon              jsol@buit5.bu.edu",
	"jlp          Jan Peterson             jlp@hamblin.byu.edu",
	"Trillian     Helen Rose               hrose@eff.org",
	"",
	"Alpha and beta testers, who put up with our bugs, and such:",
	"",
	"Fornax       Dan Goodwin              fornax@wpi.wpi.edu",
	"",
	"Thanks also goes to those persons not mentioned here who have added",
	"their advice, opinions, and code to IRC.",
	0,
    };
!SUB!THIS!
