
ColourTable::usage = "ColourTable[{x0, x1, dx}, {y0, y1, dy}, cx, cy] gives a 
table of colours based on the two colours cx and cy, that will have the same 
dimensions as Table[object, {x, x0, x1, dx}, {y, y0, y1, dy}]."

( ColourTable[{x0_, x1_, dx_}, {y0_, y1_, dy_}, cx_, cy_] := Module[
	{X, Y, min, x, y},
	{X, Y} = Dimensions @ Table[Null, {x, x0, x1, dx}, {y, y0, y1, dy}];
	lx = List @@ cx;
	ly = List @@ cy;
	min = Min /@ Thread[{lx, ly}];
	Flatten[
		Table[
			Apply[
				RGBColor, 
				min 	+ (x - 1) / (X - 1) (lx - min) 
					+ (y - 1) / (Y - 1) (ly - min) 
			],
			{x, X}, {y, Y}
		], 
		1
	]
] )

