
Invert::usage = "Invert[u][g] is the inversion of the figure g in the 
circle or sphere u."

( Invert[u_] @ p:{_?NumberQ, _?NumberQ, _?NumberQ} := 
	First @ u + Last[u] ^ 2 # / (# . #) & [p - First @ u] 
	/; Head @ u === Circle || Head @ u === Sphere
)

Invert[u_] @ Point @ p_ := Point @ Invert[u] @ p

( Invert[u_] @ Line @ {p_, q_} := Circumcircle @ Invert[u] @ 
	Take[
		Complement[
			{p, q, p + 1 / 3 (q - p), p + 2 / 3 (q - p)},
			{First @ u}
		],
		3
	]
	/; Head @ u === Circle || Head @ u === Sphere
)

Invert[u_] @ Line @ l_List := Line @ Invert[u] @ l 

Invert[u_] @ Polygon @ l_List := Polygon @ Invert[u] @ l 

( Invert[u:Circle[c_, _]] @ Circle[d_, s_] := Circumcircle @ Invert[u] @ 
	Take[
		Complement[
				Translate[d][s {$i, $j, -$i, -$j}], 
				{c}
		],
		3
	]
)

Invert[u_Circle] @ d_Disk := Disk @@ Invert[u][Circle @@ d]

( Invert[u_] @ Text[t_, p:{_?NumberQ, _?NumberQ, _?NumberQ}, a___] := 
	Text[t, Invert[u] @ p, a] )

Invert[_] @ GrayLevel[i_] := GrayLevel[i] 

Invert[_] @ RGBColor[r_, g_, b_] := RGBColor[r, g, b] 

Invert[_] @ PointSize[s_] := PointSize[s] 

Invert[_] @ Thickness[t_] := Thickness[t] 

Invert[_] @ Dashing[d_] := Dashing[d] 

Invert[u_] @ l_List := Invert[u] @ # & /@ l

Invert[u_List] @ g_ := Invert[#] @ g & /@ u

