
PreDrawyz::usage = "PreDrawyz[f] prepares the figure f for drawing."

PreDrawyz @ Point[{x_, y_}] := Point[{y, 0}]

PreDrawyz @ Point[{x_, y_, z_}] := Point[{y, z}]

PreDrawyz @ Line @ h_ := Line[Take[#, -2] & /@ h] 

PreDrawyz @ Polygon @ h_ := Polygon[Take[#, -2] & /@ h] 

( PreDrawyz @ Circle[c_, r_] := 
	PreDrawyz @ Line @ Map[c + r (Cos[#] $j + Sin[#] $k) &, 
	2 N[Pi] Range[0, 1, 1 / PointsOnCircle]] )

PreDraw @ u_Circle3D := PreDrawyz @ PreDraw3D @ u

PreDraw @ w_Plane := PreDrawyz @ PreDraw3D @ w

PreDrawyz @ Sphere[{a_, b_, c_}, r_] := PreDrawyz @ Circle[{0, b, c}, r] 

( PreDrawyz @ d_Disk := Block[
	{c = PreDrawyz[Circle @@ d]},
	{Polygon @@ c, RGBColor[0, 0, 0], c} ] )

( PreDrawyz[m_] := m 
	/; MemberQ[{GrayLevel, RGBColor, PointSize, AbsolutePointSize, 
	Thickness, AbsoluteThickness, Dashing}, Head @ m] )

PreDrawyz @ Text[x_, c_, d___] := Text[x, Take[c, -2], d]

PreDrawyz @ EdgeForm[___] := {}

PreDrawyz @ h_List := PreDrawyz /@ h


