
Reflect::usage = "2D: Reflect[l][g] is the reflection of the figure g in the 
line l. 
3D: Reflect[w][g] is the reflection of the figure g in the plane w."

( Reflect[Line @ {q_, r_}] @ p:{_?NumberQ, _?NumberQ, _?NumberQ} := Block[
	{qq, pp, rr},
	pp = Take[p, 2];
	qq = Take[q, 2];
	rr = Take[r, 2];
	Append[
	qq + PairProduct[rr - qq, PairConjugate[PairDivide[pp - qq, rr - qq]]],
	0.] ] )

( Reflect[l_Line] @ g_ := MapAt[Reflect[l] @ # &, g, 
	Position[g, {_?NumberQ, _?NumberQ, _?NumberQ}]] )

( Reflect[w_Plane] @ p:{_?NumberQ, _?NumberQ, _?NumberQ} := Block[ 
	{n, q},
	n =  Prepend[Unit @ PlaneNormal @ w, 0];
	q = First @ First @ w;
	r = Prepend[p - q, 0];
	Chop[q + Drop[QTimes[QTimes[n, r], n], 1]] ] )

( Reflect[w_Plane] @ g_ := MapAt[Reflect[w] @ # &, g, 
	Position[g, {_?NumberQ, _?NumberQ, _?NumberQ}]] )

Reflect[l_List] @ g_ := Reflect[#] @ g & /@ l

