
SpherePoints::usage = "SpherePoints[{u0, u1, du}, {v0, v1, dv}] gives a list
of points where parts of the latitudes and longitudes on the sphere cross. The
latitudes are between angles v0 and v1 with a spacing of dv. The longitudes 
are between great circles at the angles u0 and u1 with a spacing of du."

( SpherePoints[{u0_, u1_, du_}, {v0_, v1_, dv_}] := 
	Point /@ Flatten[SphereTriples[{u0, u1, du}, {v0, v1, dv}], 1] )

