/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  interval_set.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef INTERVAL_SET_H
#define INTERVAL_SET_H

#include <LEDA/d2_dictionary.h>

typedef dic2_item is_item;

declare(list,is_item)


declare3(d2_dictionary,double,double,GenPtr) 


struct Interval_Set : public d2_dictionary(double,double,GenPtr) {

double    left(is_item it) { return key1(it); }
double    right(is_item it){ return key2(it); }

list(is_item)  intersection(double, double);

 Interval_Set()  {}
~Interval_Set()  {}
};



#define interval_set(itype) name2(itype,interval_set)


#define interval_setdeclare(itype)\
\
struct interval_set(itype) : public Interval_Set{\
\
itype name2(itype,X);\
\
itype   inf(is_item it)  { return ACCESS(itype,Interval_Set::inf(it)); }\
\
is_item insert(double x, double y, itype i)\
                      { return Interval_Set::insert(x,y,Copy(i)); }\
\
void    change_inf(is_item it, itype i)\
                      { Interval_Set::change_inf(it,Copy(i)); }\
\
list(is_item)  intersection(double x, double y)\
                         { return Interval_Set::intersection(x,y); }\
\
 interval_set(itype)()  {}\
~interval_set(itype)()  {}\
};

#define forall_is_items(i,D) forall_dic2_items(i,D)

#endif

