
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) {
     (* (r->_print)) (r);
     fputs("\n", f);
  }
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGcint *_PPTGcint;
struct _SPTGcint{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGstr *_PPTGstr;
struct _SPTGstr{
  _PTGProc _print;
  int _t0;
};

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGfile(_PPTG3 n)
#else
static void _PrPTGfile(n)
_PPTG3 n;
#endif
{
  fputs ("#include <stdio.h>\n", f);
  fputs ("#include \"clplib.h\"\n", f);
  fputs ("#include \"pdl_gen.h\"\n", f);
  fputs ("\n", f);
  fputs ("DefTableKey CLP_InputFile = NoKey;\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("static int error_count = 0;\n", f);
  fputs ("\n", f);
  fputs ("void\n", f);
  fputs ("clp_init (argc, argv)\n", f);
  fputs ("int argc;\n", f);
  fputs ("char *argv[];\n", f);
  fputs ("{\n", f);
  fputs ("  int i, done = 0;\n", f);
  fputs ("  DefTableKey k;\n", f);
  fputs ("\n", f);
  fputs ("  for (i = 1; (!done) && (i < argc); i++)\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("      { done = 1; i--; }\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGtail(_PPTG2 n)
#else
static void _PrPTGtail(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("  if (CLP_InputFile == NoKey)\n", f);
  fputs ("    if (i >= argc) error_count++;\n", f);
  fputs ("    else {\n", f);
  fputs ("      CLP_InputFile = NewKey();\n", f);
  fputs ("      SetValue (CLP_InputFile, clp_string(argv[i++]),0);\n", f);
  fputs ("  }\n", f);
  fputs ("  if (error_count > 0) {\n", f);
  fputs ("    fprintf (stderr, \"Usage: %s [options] parameters\\n\",\n", f);
  fputs ("             argv[0]);\n", f);
  fputs ("    fprintf (stderr, \"  options:\\n\");\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("    exit (1);\n", f);
  fputs ("  }\n", f);
  fputs ("}\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGkdecl(_PPTG1 n)
#else
static void _PrPTGkdecl(n)
_PPTG1 n;
#endif
{
  fputs ("DefTableKey ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NoKey;\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGkkdecl(_PPTG3 n)
#else
static void _PrPTGkkdecl(n)
_PPTG3 n;
#endif
{
  fputs ("DefTableKeyList ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = (DefTableKeyList)0;\n", f);
  fputs ("static DefTableKeyList *", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end = &", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGbdecl(_PPTG1 n)
#else
static void _PrPTGbdecl(n)
_PPTG1 n;
#endif
{
  fputs ("int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = 0;\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGidecl(_PPTG1 n)
#else
static void _PrPTGidecl(n)
_PPTG1 n;
#endif
{
  fputs ("static int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_count = 0;\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGterm(_PPTG1 n)
#else
static void _PrPTGterm(n)
_PPTG1 n;
#endif
{
  fputs ("    if (strcmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\") == 0)\n", f);
  fputs ("      done = 1;\n", f);
  fputs ("    else\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGcmp(_PPTG2 n)
#else
static void _PrPTGcmp(n)
_PPTG2 n;
#endif
{
  fputs ("    if (strcmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\") == 0) {\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("    } else\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGvcmp(_PPTG3 n)
#else
static void _PrPTGvcmp(n)
_PPTG3 n;
#endif
{
  fputs ("    if (strcmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\") == 0) {\n", f);
  fputs ("      if (i == argc - 1) {\n", f);
  fputs ("        fprintf (stderr, \"Usage: \\\"", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\\\" must have a value.\\n\");\n", f);
  fputs ("        error_count++;\n", f);
  fputs ("      } else {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("      }\n", f);
  fputs ("    } else\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGjcmp(_PPTG3 n)
#else
static void _PrPTGjcmp(n)
_PPTG3 n;
#endif
{
  fputs ("    if (strncmp (argv[i], \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\", ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (") == 0) {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("    } else\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGbool(_PPTG2 n)
#else
static void _PrPTGbool(n)
_PPTG2 n;
#endif
{
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = 1;\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGbools(_PPTG2 n)
#else
static void _PrPTGbools(n)
_PPTG2 n;
#endif
{
  fputs ("      k = NewKey();\n", f);
  fputs ("      SetValue (k, 1, 0);\n", f);
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGintval(_PPTG3 n)
#else
static void _PrPTGintval(n)
_PPTG3 n;
#endif
{
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("        SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",atoi(argv[++i]),0);\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGintvals(_PPTG2 n)
#else
static void _PrPTGintvals(n)
_PPTG2 n;
#endif
{
  fputs ("        k = NewKey();\n", f);
  fputs ("        SetValue (k, atoi(argv[++i]), 0);\n", f);
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGjintval(_PPTG4 n)
#else
static void _PrPTGjintval(n)
_PPTG4 n;
#endif
{
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("      SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",atoi(argv[i]+", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("),0);\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGjintvals(_PPTG3 n)
#else
static void _PrPTGjintvals(n)
_PPTG3 n;
#endif
{
  fputs ("      k = NewKey();\n", f);
  fputs ("      SetValue (k, atoi(argv[i]+", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("), 0);\n", f);
  fputs ("      ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("_end, k);\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGstrval(_PPTG3 n)
#else
static void _PrPTGstrval(n)
_PPTG3 n;
#endif
{
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("        SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",clp_string(argv[++i]),0);\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGstrvals(_PPTG2 n)
#else
static void _PrPTGstrvals(n)
_PPTG2 n;
#endif
{
  fputs ("        k = NewKey();\n", f);
  fputs ("        SetValue (k, clp_string(argv[++i]), 0);\n", f);
  fputs ("        ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGjstrval(_PPTG4 n)
#else
static void _PrPTGjstrval(n)
_PPTG4 n;
#endif
{
  fputs ("      ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("      SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",clp_string(argv[i]+", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("),0);\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGjstrvals(_PPTG3 n)
#else
static void _PrPTGjstrvals(n)
_PPTG3 n;
#endif
{
  fputs ("      k = NewKey();\n", f);
  fputs ("      SetValue (k, clp_string(argv[i]+", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("), 0);\n", f);
  fputs ("      ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("_end, k);\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGctest(_PPTG2 n)
#else
static void _PrPTGctest(n)
_PPTG2 n;
#endif
{
  fputs ("      if (++ ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_count > 1) {\n", f);
  fputs ("        fprintf (stderr, \"Usage: \\\"", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\\\" can only be given once.\\n\");\n", f);
  fputs ("        error_count++;\n", f);
  fputs ("      }\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGparam(_PPTG3 n)
#else
static void _PrPTGparam(n)
_PPTG3 n;
#endif
{
  fputs ("  if (i >= argc)\n", f);
  fputs ("    error_count++;\n", f);
  fputs ("  else {\n", f);
  fputs ("    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" = NewKey();\n", f);
  fputs ("    SetValue (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (",clp_string(argv[i++]),0);\n", f);
  fputs ("    if (CLP_InputFile == NoKey) CLP_InputFile = ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
  fputs ("  }\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmparam(_PPTG2 n)
#else
static void _PrPTGmparam(n)
_PPTG2 n;
#endif
{
  fputs ("  for (; i < argc; i++) {\n", f);
  fputs ("    k = NewKey();\n", f);
  fputs ("    SetValue (k, clp_string(argv[i]), 0);\n", f);
  fputs ("    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("_end = Append (DefTableKey, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("_end, k);\n", f);
  fputs ("    if (CLP_InputFile == NoKey) CLP_InputFile = k;\n", f);
  fputs ("  }\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGtuse(_PPTG1 n)
#else
static void _PrPTGtuse(n)
_PPTG1 n;
#endif
{
  fputs ("    fprintf (stderr, \"    option terminator: ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGbsuse(_PPTG2 n)
#else
static void _PrPTGbsuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGbpuse(_PPTG2 n)
#else
static void _PrPTGbpuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGisuse(_PPTG2 n)
#else
static void _PrPTGisuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGisjuse(_PPTG2 n)
#else
static void _PrPTGisjuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGipuse(_PPTG2 n)
#else
static void _PrPTGipuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGipjuse(_PPTG2 n)
#else
static void _PrPTGipjuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("int: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGssuse(_PPTG2 n)
#else
static void _PrPTGssuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGssjuse(_PPTG2 n)
#else
static void _PrPTGssjuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (at most once)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGspuse(_PPTG2 n)
#else
static void _PrPTGspuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGspjuse(_PPTG2 n)
#else
static void _PrPTGspjuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"    ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("str: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGpuse(_PPTG2 n)
#else
static void _PrPTGpuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"  param ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGppuse(_PPTG2 n)
#else
static void _PrPTGppuse(n)
_PPTG2 n;
#endif
{
  fputs ("    fprintf (stderr, \"  param ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" (may be repeated)\\n\");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGheader(_PPTG1 n)
#else
static void _PrPTGheader(n)
_PPTG1 n;
#endif
{
  fputs ("#include \"clplib.h\"\n", f);
  fputs ("\n", f);
  fputs ("extern DefTableKey CLP_InputFile;\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGkextern(_PPTG1 n)
#else
static void _PrPTGkextern(n)
_PPTG1 n;
#endif
{
  fputs ("extern DefTableKey ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGkkextern(_PPTG1 n)
#else
static void _PrPTGkkextern(n)
_PPTG1 n;
#endif
{
  fputs ("extern DefTableKeyList ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGiextern(_PPTG1 n)
#else
static void _PrPTGiextern(n)
_PPTG1 n;
#endif
{
  fputs ("extern int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGseq(_PPTG2 n)
#else
static void _PrPTGseq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGcint(_PPTGcint n)
#else
static void _PrPTGcint(n)
_PPTGcint n;
#endif
{
  fprintf (f, "%d",n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
extern void OutStr(FILE *, int);
#else
extern void OutStr();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGstr(_PPTGstr n)
#else
static void _PrPTGstr(n)
_PPTGstr n;
#endif
{
  OutStr(f,n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGfile(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGfile(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGfile;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGtail(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGtail(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGtail;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGkdecl(PTGNode _t0)
#else
PTGNode PTGkdecl(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGkdecl;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGkkdecl(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGkkdecl(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGkkdecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGbdecl(PTGNode _t0)
#else
PTGNode PTGbdecl(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGbdecl;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGidecl(PTGNode _t0)
#else
PTGNode PTGidecl(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGidecl;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGterm(PTGNode _t0)
#else
PTGNode PTGterm(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGterm;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGcmp(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGcmp(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGcmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGvcmp(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGvcmp(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGvcmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGjcmp(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGjcmp(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGjcmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGbool(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGbool(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGbool;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGbools(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGbools(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGbools;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGintval(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGintval(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGintval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGintvals(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGintvals(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGintvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGjintval(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3)
#else
PTGNode PTGjintval(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
#endif
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGjintval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGjintvals(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGjintvals(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGjintvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGstrval(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGstrval(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGstrval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGstrvals(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGstrvals(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGstrvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGjstrval(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3)
#else
PTGNode PTGjstrval(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
#endif
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGjstrval;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGjstrvals(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGjstrvals(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGjstrvals;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGctest(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGctest(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGctest;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGparam(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGparam(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGparam;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmparam(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGmparam(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmparam;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGtuse(PTGNode _t0)
#else
PTGNode PTGtuse(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGtuse;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGbsuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGbsuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGbsuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGbpuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGbpuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGbpuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGisuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGisuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGisuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGisjuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGisjuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGisjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGipuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGipuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGipuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGipjuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGipjuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGipjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGssuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGssuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGssuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGssjuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGssjuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGssjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGspuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGspuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGspuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGspjuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGspjuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGspjuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGpuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGpuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGpuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGppuse(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGppuse(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGppuse;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGheader(PTGNode _t0)
#else
PTGNode PTGheader(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGheader;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGkextern(PTGNode _t0)
#else
PTGNode PTGkextern(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGkextern;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGkkextern(PTGNode _t0)
#else
PTGNode PTGkkextern(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGkkextern;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGiextern(PTGNode _t0)
#else
PTGNode PTGiextern(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGiextern;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGseq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGseq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGseq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGcint(int _t0)
#else
PTGNode PTGcint(_t0)
  int _t0;
#endif
{
  _PPTGcint n;

  if ((n = (_PPTGcint) malloc (sizeof (struct _SPTGcint)))  ==  (_PPTGcint)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGcint;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGstr(int _t0)
#else
PTGNode PTGstr(_t0)
  int _t0;
#endif
{
  _PPTGstr n;

  if ((n = (_PPTGstr) malloc (sizeof (struct _SPTGstr)))  ==  (_PPTGstr)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGstr;
  n->_t0=_t0;
  return ((PTGNode) n);
}


