# (C) Copyright International Business Machines Corporation 23 January
# 1990.  All Rights Reserved.
# 
# See the file USERAGREEMENT distributed with this software for full
# terms and conditions of use.
# File: tex2nroff.awk
# Author: Andy Lowry
# SCCS Info: @(#)tex2nroff.awk	1.3 3/13/90

# This is a limited awk script for translating latex input to a form
# suitable for nroff so straight text can be produced.  Only what is
# needed for current documents is in here, so if you change them or
# need to convert a new document, you'll probably need to change this.
# The output file should be sent through nroff with the -ms macro
# package.

# The following are all considered no-ops.  This unfortunate for
# \input, but it's not so easy do incorporate it via an awk script.
/\\documentstyle/ {next}
/\\setlength/ {next}
/\\addtolength/ {next}
/\\input/ {next}
# Multi-line defines screw up
/\\def/ {next}
/\\begin/ {next}
/\\end/ {next}
/\\vskip/ {next}
/^[ \t]*%/ {next}

# paragraph breaks
/^[ \t]*$/ {
  print ".LP"
  next
}

# Get rid of braces and no-op inline control sequences
{
  junk = "{"
  line = $0
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) " " substr(line, pos+length(junk))
  }
  junk = "}"
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) " " substr(line, pos+length(junk))
  }
  junk = "\\bf "
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) " " substr(line, pos+length(junk))
  }
  junk = "\\em "
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) " " substr(line, pos+length(junk))
  }
  junk = "\\tt "
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) " " substr(line, pos+length(junk))
  }
  junk = "\\it "
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) " " substr(line, pos+length(junk))
  }
  junk = "---"
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) "\*-" substr(line, pos+length(junk))
  }
  junk = "--"
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) "-" substr(line, pos+length(junk))
  }
  junk = "``"
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) "\*Q" substr(line, pos+length(junk))
  }
  junk = "''"
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) "\U-" substr(line, pos+length(junk))
  }
  junk = " ."
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) "." substr(line, pos+length(junk))
  }
  junk = " ,"
  while (1) {
    pos = index(line, junk)
    if (pos == 0) 
      break
    line = substr(line, 1, pos-1) "," substr(line, pos+length(junk))
  }

  while (index(" \t", substr(line, 1, 1)) != 0)
    line = substr(line, 2)
}

# unnumbered section
substr(line, 1, 9) == "\\section*" {
  secname = substr(line, 10)
  while (index(" \t", substr(secname, 1, 1)) != 0)
    secname = substr(secname, 2)
  printf(".SH\n%s\n", secname)
  next
}

# bulleted items
substr(line, 1, 5) == "\\item" {
  itmtext = substr(line, 6)
  while (index(" \t", substr(itmtext, 1, 1)) != 0)
    itmtext = substr(itmtext, 2)
  printf(".IP \n%s\n", itmtext)
  next
}

substr(line, 1, 9) == "\\leftline" {
  linetxt = substr(line, 10)
  while (index(" \t", substr(linetxt, 1, 1)) != 0)
    linetxt = substr(linetxt, 2)
  printf(".LP\n%s\n", linetxt)
  next
}

# Anything else gets put out verbatim
{
  print line
}
