/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#define _BSD 43
#include <assert.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/param.h>

#include "cfunc.h"

#include "cwindow.cd"

#undef read
#undef write

#ifndef FNDELAY
#  define FNDELAY O_NDELAY
#endif

CProc(C_window)
{
  int makewindow();

  lobject(callmessage);
  objectp initport;
  int in,out;
  char *label,*options;
  
  initport = & current->ep.c->initport;
  
  (void) copy(callmessage,Bottom);
  if (c_receive(callmessage,initport) is SUCCESS)
    {
      /* Process the callmessage */
      label = stringval(callmessage@cwindow__label);
      options = stringval(callmessage@cwindow__options);
      if (makewindow(&in,&out,label,options) is FAILURE)
	{
	  /* Failed open */
#ifdef SIGNALIO_DEBUG
	  printf("Discarding callmessage.\n");
	  (void) fflush(stdout);
#endif
	  /* Discard the callmessage */
	  (void) discard(callmessage);
	}
      else
	{
	  /* Successful open */
#ifdef SIGNALIO_DEBUG
	  printf("Returning in = %d, out = %d.\n",in,out);
	  (void) fflush(stdout);
#endif
	  (void) ilit(callmessage@cwindow__in,in);
	  (void) ilit(callmessage@cwindow__out,out);
	  /* Return the callmessage */
	  c_return(sched, callmessage);
	}
    }
  c_wait(sched, current, initport);
}

int makewindow(infd,outfd,label,options)
     int *infd,*outfd;
     char *label,*options;
{
  /* In is towards parent, out is towards child */
  int in[2], out[2];
  char *wprogname();		/* produces window program name */
  char *wprog;

#ifdef SIGNALIO_DEBUG
  printf(">Opening window \"%s\" with options \"%s\".\n",label,options);
#endif
  if (pipe(in))
    {
#ifdef SIGNALIO_DEBUG
      fprintf(stderr,"Error creating pipes, window not opened.\n");
#endif
      return FAILURE;
    }
  if (pipe(out))
    {
      close(in[0]); 
      close(in[1]);
#ifdef SIGNALIO_DEBUG
      fprintf(stderr,"Error creating pipes, window not opened.\n");
#endif
      return FAILURE;
    }
  if (fork())
    {
      /* Parent process */
      *infd = in[0];
      fcntl(*infd,F_SETOWN,getpid());
      fcntl(*infd,F_SETFD,1);
      fcntl(*infd,F_SETFL,FASYNC|FNDELAY|fcntl(*infd,F_GETFL,0));

      *outfd = out[1];
      fcntl(*outfd,F_SETOWN,getpid());
      fcntl(*outfd,F_SETFD,1);
      fcntl(*outfd,F_SETFL,FASYNC|FNDELAY|fcntl(*outfd,F_GETFL,0));

      close(in[1]);
      close(out[0]);
      return SUCCESS;
    }
  else
    {
      /* Child process */
      dup2(in[1],fileno(stdout));
      close(in[0]);
      close(in[1]);
      dup2(out[0],fileno(stdin));
      close(out[0]);
      close(out[1]);
      /* get name of window manager */
      if ((wprog = wprogname()) isnt NULL)
	execl(wprogname(),"window",label,options,0);
      exit(1);
      /*NOTREACHED*/
    }
}

/* Following program produces window program name based on */
/* machine-dependent binaries directory and environment variables */
/* indicating which window system is running */

static char *
wprogname()
{
  char *hmbindir(), *getenv();
  char wprog[MAXPATHLEN+1];
  
  if (getenv("DISPLAY") isnt NULL)
    sprintf(wprog,"%s/xwindow",hmbindir());
  else if (getenv("WINDOW_PARENT") isnt NULL)
    sprintf(wprog,"%s/sunwindow",hmbindir());
  else
    return(NULL);
  return(wprog);
}
