-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: lkuptype.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)lkuptype.pp	1.4 3/13/90

-- This process looks up the typename of a given root object.  A given
-- collection of scopes is examined first, and then the given table of
-- inferred definitions is examined if that fails.

#include "typemark.h"
#include "codegen.h"

lkupType: using (cgInternal)

process (Q: lkupTypeQ)
  
declare
  args: lkupType;
begin
  receive args from Q;
  
  inspect scope in args.scopes[args.obj.scope] begin
    inspect decl in scope.declarations[args.obj.root] begin
      if B(typename_option#(case of decl.typename) =
	      typename_option#'named') then
	reveal decl.typename.typename;
	args.type := decl.typename.typename;
      else
	-- No declaration in absprog... we'll need one from inferred defs
	inspect infDef in args.infDefs[args.obj] begin
	  args.type := infDef.type;
	end inspect;
      end if;
    end inspect;
  end inspect;
  
  return args;
end process
