/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: definition.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)definition.ch	1.9 3/13/90";
#endif

#include "cherm.h"

#include "resolve.h"
#include "predefined.cd"
#include "errors.cd"

#define DEFAULT_ENUM_SIZE 0

void add_type_def();

static char *defname;		/* name of type or attribute being defined. */
static char *pragm;		/* pragma for current definition */

static objectp Enumelements;	/* elements of the current enumeration being */
				/*  defined. */
hobject(Seenenums);		/* those enumeration values which have */
				/*  already been defined (used for duplicate */
				/*  checking). */
static int forwardseen;		/* how many of Enumelements were defined by */
				/*  forward reference. */

objectp Backpatch;		/* unres_type: also used in p_decl.ch */


static void
no_components(Def)
objectp Def;
{
    ord_avl_new_table(Def@type_definition__component_declarations,
		      firstelem_key, nil);
				/* allocate a table but don't use any space */
				/*  for elements since there aren't any */
				/*  components. */
}


void
p_def_name(name, pragma_string)
char *name;			/* constant(?) string: type or attr being def'd */
char *pragma_string;		/* string: pragma */
{
    objectp bp_deftype();


    defname = copystring(name);
    Backpatch = bp_deftype(defname);

    pragm = pragma_string;	/* save pragma */
}



static objectp
make_type_definition(enumvalue)
dfd_enumeration enumvalue;
{
    objectp Typedef;


    Typedef = new_object();
    new_record(Typedef, type_definition);

    if (Backpatch) {		/* if name was in backpatch table...? */
	copy(Typedef@Id, Backpatch@Id);	/*   use assigned typeid */
    }
    else {
	unique(Typedef@Id);	/*   else assign a new typeid */
	(void) add_type_printname(defname,Typedef@Id);
				/* ...and add printmap entry */
    }

    unite(Typedef@type_definition__specification, Bottom, enumvalue);
				/* create the variant with the case tag */
				/*  for the type. */

    return(Typedef);
}


void
p_nominal_def()
{
    objectp Def;

    Def = make_type_definition(primitive_types__nominaltype);
    no_components(Def);
    add_type_def(Def);
}


void
p_integer_def()
{
    objectp Def;

    Def = make_type_definition(primitive_types__integertype);
    no_components(Def);
    add_type_def(Def);
}


void
p_polymorph_def()
{
    objectp Def;

    Def = make_type_definition(primitive_types__polymorphtype);
    no_components(Def);
    add_type_def(Def);
}


void
p_real_def(numerator, denominator)
char *numerator, *denominator;
{
    int atoi();

    hobject(SAccuracy,record);
    objectp Def;


    Def = make_type_definition(primitive_types__realtype);
    no_components(Def);

    new_record(SAccuracy, accuracy_info);

    ilit(SAccuracy@accuracy_info__accuracy_numerator, atoi(numerator));
    ilit(SAccuracy@accuracy_info__accuracy_denominator, atoi(denominator));
				/* put in the fields. */

    move(Def@type_definition__specification@Component, SAccuracy);
				/* move record into the component field */
				/*  of the variant. */

    add_type_def(Def);
}


void
p_boolean_def(truename, falsename)
char *truename;
char *falsename;
{
    objectp Def;


    Def = make_type_definition(primitive_types__booleantype);
    no_components(Def);

    new_record(Def@type_definition__specification@Component, boolean_info);

    chs_lit(Def@type_definition__specification@Component@boolean_info__true_name, truename);
    chs_lit(Def@type_definition__specification@Component@boolean_info__false_name, falsename);


    add_type_def(Def);
}


void
p_init_enum_elements()
{
    objectp bp_enumdef();


    if (Backpatch) {
	Enumelements = bp_enumdef(Backpatch);
	forwardseen = size_of(Enumelements);
    }
    else {
	Enumelements = new_object();
	ord_avl_new_table(Enumelements, whole_key, nil);
	forwardseen = 0;
    }

    avl_new_table(Seenenums, whole_key, nil);
}
    

objectp
p_get_enum_elements()
{
    return(Enumelements);
}


void
p_add_enum(name)
char *name;
{
    hobject(SName);


    chs_lit(SName, name);
    if (insert(Seenenums, SName) is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Component '%s' of type %s used more than once", name, 
		 defname);
	discard(SName);
    }
    else {
	chs_lit(SName, name);
	if (insert(Enumelements, SName) is DuplicateKey) {
	    discard(SName);
	    forwardseen--;
	}
    }
}


void
p_enum_def(ordered,Enumlist)
dfd_boolean ordered;		/* is it an ordered enumeration? */
objectp Enumlist;		/* object table: list of enum literals */
{
    objectp Def;


    if (forwardseen isnt 0)
      fe_error(Inhibit_Codegen, errorcode__general_error,
	       "A component of type %s was used but not defined", defname);

    Def = make_type_definition(primitive_types__enumerationtype);
    no_components(Def);

    new_record(Def@type_definition__specification@Component, enumeration_info);

    h_boolean(Def@type_definition__specification@Component@enumeration_info__ordered, ordered);
    move(Def@type_definition__specification@Component@enumeration_info__values, Enumlist);

    add_type_def(Def);

    discard(Seenenums);
}


void
p_outport_def(Type)
objectp Type;			/* in typename */
{
    objectp lookup_typename();

    objectp Def;		/* type_definition */
    objectp Iptype;		/* type_definition */

#ifdef PRETYPECHECK
    /* make sure it's an inport type */

    Iptype = lookup_typename(Type);
    if (case_of(Iptype@type_definition__specification) isnt 
	primitive_types__inporttype) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Type '%s' must be an input port type",
		 pmap_type(Type));
      }
#endif

    Def = make_type_definition(primitive_types__outporttype);
    no_components(Def);
    move(Def@type_definition__specification@Component, Type);

    add_type_def(Def);
}


void
p_inport_def(Type, Typestate)
objectp Type;			/* typename */
objectp Typestate;		/* formal_typestate */
{
    objectp Def;

    Def = make_type_definition(primitive_types__inporttype);
    no_components(Def);
    new_record(Def@type_definition__specification@Component,inport_info);
    move(Def@type_definition__specification@Component@inport_info__message_type, Type);
    move(Def@type_definition__specification@Component@inport_info__message_typestate, Typestate);


    add_type_def(Def);
}


void
p_init_record_def()
{
    /* sigh... another global due to yacc's one pass nature. */

    Currentdefinition = make_type_definition(primitive_types__recordtype);
}


void
p_record_def(Componentlist)
objectp Componentlist;		/* in component_declarations */
{
    void check_declaration_list();

    check_declaration_list(Backpatch, Componentlist);
				/* check that all forward referenced */
				/*  components were defined. */
    move(Currentdefinition@type_definition__component_declarations,
	 Componentlist);
    add_type_def(Currentdefinition);
}



static objectp Casetype;	/* type_definition */
hobject(SPartitionset,table); /* partition_set */
hobject(SCases_used,table);	/* stringtable */

void
p_init_variant_def(Typename)
objectp Typename;		/* in type_name: case type */
{
    objectp lookup_typename();

    hobject(SVinfo, record);	/* variant_info */


    Casetype = lookup_typename(Typename);

#ifdef PRETYPECHECK
    if (case_of(Casetype@type_definition__specification) isnt 
	primitive_types__enumerationtype) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Type '%s' must be an enumeration type",
		 pmap_type(Typename));
    }
#endif

    Currentdefinition = make_type_definition(primitive_types__varianttype);
    new_record(SVinfo, variant_info);
    move(SVinfo@variant_info__case_type, Typename);

    move(Currentdefinition@type_definition__specification@Component, SVinfo);

    p_init_declaration_list();
    avl_new_table(SPartitionset, firstelem_key);
    avl_new_table(SCases_used, whole_key);
}


void
p_add_variant_case(litname, Declaration, Formaltypestate)
char *litname;			/* in string: name of case */
objectp Declaration;		/* in declaration: component declaration */
objectp Formaltypestate;	/* in formal_typestate: typestate of case */
/* objectp Casetype;               global constant type_definition */
/* objectp SPartitionset;           global inout partition_set */
/* objectp SCases_used;             global inout stringtable */
{
    dfd_integer resolve_enumval();
    objectp p_add_declaration();
    objectp typename_in_module();

    hobject(Partinfo, record);	/* partition_info */
    hobject(SLitname, chs_table);
    objectp CDeclid;		/* declaration */
    dfd_integer enumvalue;


    CDeclid = p_add_declaration(Declaration);
				/* add declaration of component */

    new_record(Partinfo, partition_info);
    copy(Partinfo@Id, CDeclid); /* copy id from declaration */

    enumvalue = resolve_enumval(Casetype, litname);
    if (enumvalue is -1)
      fe_error(Inhibit_Codegen, errorcode__general_error,
	       "Name '%s' is not a value in the enumeration type '%s'",
	       litname,
	       pmap_type(typename_in_module(Casetype@type_definition__id)));
    chs_lit(SLitname, litname);
    if (insert(SCases_used, SLitname) is DuplicateKey) {
      fe_error(Inhibit_Codegen, errorcode__general_error,
	       "Name '%s' labels multiple cases in variant type '%s'",
	       litname,
	       pmap_type(typename_in_module(Casetype@type_definition__id)));
      discard(SLitname);
    }

    ilit(Partinfo@partition_info__case_id, enumvalue);
    move(Partinfo@partition_info__case_typestate, Formaltypestate);

    if (insert(SPartitionset, Partinfo) isnt Normal) {
	fe_error(Fatal, errorcode__general_error,
		 "p_add_variant_case",
		 "Component ID already exists in variant definition");
	discard(Partinfo);
    }
}


void
p_variant_def()
{
    objectp p_get_declaration_list();
    objectp typename_in_module();
    void check_declaration_list();

    objectp Declist;

#ifdef PRETYPECHECK
    if (size_of(SCases_used) <
	size_of(Casetype@type_definition__specification@Component@enumeration_info__values))
      fe_error(Inhibit_Codegen, errorcode__general_error,
	       "Cases missing from definition of variant type '%s'",
	       pmap_type(typename_in_module(Casetype@type_definition__id)));
#endif

    move(Currentdefinition@type_definition__specification@Component@variant_info__case_mapping,
	 SPartitionset);
    Declist = p_get_declaration_list();
    move(Currentdefinition@type_definition__component_declarations, Declist);

    check_declaration_list(Backpatch, Declist);
				/* check that all forward referenced */
				/*  components were defined. */
    discard(SCases_used);

    add_type_def(Currentdefinition);
}


void				/* out type_definition */
p_table_def(ordered, Typename, Formalts, Keydefs)
dfd_boolean ordered;		/* in boolean: ordered table? */
objectp Typename;		/* in typename: element type */
objectp Formalts;		/* in formal_typestate: element ts */
objectp Keydefs;		/* in keydefs */
{
    objectp Def;
    objectp Spec;

    Def = make_type_definition(primitive_types__tabletype);
    no_components(Def);
    new_record(Def@type_definition__specification@Component, table_info);
    Spec = Def@type_definition__specification@Component;

    h_boolean(Spec@table_info__ordered_table, ordered);
    move(Spec@table_info__element_type, Typename);
    move(Spec@table_info__element_typestate, Formalts);

    if (Keydefs) {
	move(Spec@table_info__keys, Keydefs);
    }
    else {			/* make empty keyset */
	avl_new_table(Spec@table_info__keys, whole_key);
    }


    add_type_def(Def);
}



void
p_init_callmsg_def()
{
    Currentdefinition = make_type_definition(primitive_types__callmessagetype);
    new_record(Currentdefinition@type_definition__specification@Component,
	       callmessage_info);
    avl_new_table(Currentdefinition@type_definition__specification@Component@callmessage_info__exception_specifications,
		  firstelem_key);
    avl_new_table(Currentdefinition@type_definition__specification@Component@callmessage_info__constants,
		  whole_key);
}


static objectp Callmsgname;

void
p_set_callmsg(Componentlist)
objectp Componentlist;		/* in component_declarations */
{
    objectp get_defmodid();
    void check_declaration_list();

    objectp Defcopy;


    check_declaration_list(Backpatch, Componentlist);
				/* check that all forward referenced */
				/*  components were defined. */

    move(Currentdefinition@type_definition__component_declarations,
	 Componentlist);

    Defcopy = new_object();	/* insert definition, but keep a cheapcopy */
    cheapcopy(Defcopy, Currentdefinition);
    add_type_def(Defcopy);

    Callmsgname = new_object();	/* build type name for this type */
    new_record(Callmsgname, typename);
    copy(Callmsgname@typename__moduleid, get_defmodid()); 
    copy(Callmsgname@typename__typeid, Currentdefinition@Id);

    p_set_resenv(Callmsgname);
}


static objectp
add_callmsg_exception(Excepstate)
objectp Excepstate;		/* in predefined!formal_typestate */
{
    hobject(Excep, record);	/* predefined!exception */
    objectp Excepid;		/* predefined!exceptionid */

    new_record(Excep, exception);
    unique(Excep@Id);
    move(Excep@exception__post_typestate, Excepstate);

    Excepid = Excep@Id;

    insert(Currentdefinition@type_definition__specification@Component@callmessage_info__exception_specifications,
	       Excep);

    return(Excepid);
}



void
p_callmsg_exception(name, Excepstate)
char *name;			/* in string */
objectp Excepstate;		/* in predefined!formal_typestate */
{
    add_exception_printname(name, Currentdefinition@Id,
			    add_callmsg_exception(Excepstate));
}


void
p_add_callmsg_constant(name)
char *name;
{
    objectp byname_component_lookup();

    objectp Compdecl;		/* component_declaration */
    hobject(SCompid, nominal);	/* componentid */

    Compdecl = byname_component_lookup(Callmsgname, name);

    if (Compdecl) {		/* byname lookup may fail and return nil */
				/*  if component name is undefined. */
	copy(SCompid, Compdecl@Id);
	if (insert(Currentdefinition@type_definition__specification@Component@callmessage_info__constants,
		       SCompid) is DuplicateKey) {
	    fe_error(Inhibit_Codegen, errorcode__general_error,
		     "Component '%s' appears multiple times in constants list for type '%s'",
		     name, pmap_type(Callmsgname));

	    discard(SCompid);
	}

    }
}



void
p_callmsg_def(Exitstate, Minstate)
objectp Exitstate;
objectp Minstate;
{
    objectp Cminfo;
    objectp minExc;

    Cminfo = Currentdefinition@type_definition__specification@Component;

    move(Cminfo@callmessage_info__normal, Exitstate);

    if (Minstate is nil) {	/* no minimum supplied? */
	Minstate = new_object(); /* generate an empty one */
	avl_new_table(Minstate, whole_key);
    }

    minExc = add_callmsg_exception(Minstate);
    copy(Cminfo@callmessage_info__minimum, minExc);
				/* add the exception and record its id */
    add_exception_printname("discarded", Currentdefinition@Id, minExc);
				/* and put it in the printmap with a */
				/* fixed name */
}



static void
add_type_def(Construction)
objectp Construction;		/* in type_definition */
{
    if (pragm) 
      {
	  chs_lit(Construction@type_definition__prag, pragm);
      } 
    else 
      {
	  chs_lit(Construction@type_definition__prag, "");
      }

    insert(Typedefinitions, Construction);

}


static dfd_integer
resolve_enumval(Enumdef, name)
objectp Enumdef;		/* constant type_definition */
char *name;			/* constant string: enumeration literal */
{
    objectp Enumtable;
    hobject(Pos, integer);
    hobject(Enumstring, charstring);

    
    if (Enumdef is nil) {	/* is this a forward resolution? */
	return(bp_enumval(name, Currentdefinition@type_definition__specification@Component@variant_info__case_type));
    }

    if (case_of(Enumdef@type_definition__specification) isnt 
	primitive_types__enumerationtype) {
	return(0);
    }

    Enumtable = Enumdef@type_definition__specification@Component@enumeration_info__values;

    initget(Enumstring, Enumtable, nil);
    while (get_or_err(Enumstring, Enumtable) is Normal) 
      if (strcmp(name, stringval(Enumstring)) is 0) {
	  position(Pos, Enumstring);
	  return(integerval(Pos));
      }

    return(-1);			/* not found */
}

static objectp
typename_in_module(typeid)
objectp typeid;
{
  objectp get_defmodid();
  hobject(Typename);

  new_record(Typename, typename);
  copy(Typename@typename__moduleid, get_defmodid());
  copy(Typename@typename__typeid, typeid);
  return(Typename);
}
