-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)cwd.p	1.2 3/13/90

cwd: using (cwd, initCwd)

process ( initQ: initCwdQ )

declare
  initArgs: initCwd;
  cwd: charstring;
  setQ: setCwdQ;
  getQ: getCwdQ;

begin
  new setQ;
  new getQ;

  receive initArgs from initQ;
  cwd := initArgs.directory;
  connect initArgs.getCwd to getQ;
  connect initArgs.setCwd to setQ;
  return initArgs;

  while boolean#'true' repeat
    select
      event getQ
	block
	  declare
	    args: getCwd;
	  begin
	    receive args from getQ;
	    args.cwd := cwd;
	    return args;
	end block;

      event setQ
	block
	  declare
	    args: setCwd;
	  begin
	    receive args from setQ;
	    cwd := args.directory;
	-- should be checking the validity of the directory here and returning
	--  badDirectory if no good.
	    return args;
	end block;

      otherwise
    end select;
  end while;
end process
