-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getpaths.pp
-- Author: David F. Bacon
-- SCCS Info: @(#)getpaths.pp	1.4 3/13/90

-- requires ENVIRON to be #define'd to the root!environ variable, and the
-- following declarations:
--
--   bindir: charstring
--   syspath: charstring;
--   defpath: charstring;

block 
  declare
    enventry: root!enventry;
    hroot: charstring;
    
 begin
-- Find the root of the hermes tree, as given by the
-- environment variable HROOTDIR, which must be defined.
   enventry <- enventry#( e in ENVIRON where ( boolean#( e.variable =
	     charstring#"HROOTDIR" ) ) );
   hroot := enventry.value;

-- Now locate the binary directory
   bindir <- charstring#(hroot | charstring#"/bin");

-- get the paths
   block begin
       enventry <- enventry#( e in ENVIRON where ( boolean#( e.variable =
		      charstring#"HPATH" ) ) );
       defpath <- enventry.value;
     on (NotFound)
       defpath <- charstring#(charstring#".:" | bindir);
     end block;

   block begin
       enventry <- enventry#( e in ENVIRON where ( boolean# ( e.variable =
		      charstring#"HLOADPATH" ) ) );
       syspath <- enventry.value;
     on (NotFound)
       syspath := defpath;
     end block;
   
   
 end block;
