-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)getchar.p	1.2 3/13/90

getChar: using (predefined, terminalIO, terminalInits, unix)
process (initQ: initGetCharQ)

declare
  init: initGetCharIntf;
  fgetc: fgetc_function;
  getCharQ: getCharQ;
  getChar: getCharIntf;
  file: handle;
  intchar: int;

begin
  receive init from initQ;
  fgetc := init.fgetc;
  file := init.file;
  new getCharQ;
  connect init.getChar to getCharQ;
  return init;

  while boolean#'true' repeat
    receive getChar from getCharQ;

    call fgetc(file, intchar);

    if boolean#(intchar >= int#0) then
      getChar.char := char#(convert of intchar);
      return getChar;
    else
      return getChar exception endOfInput;
    end if;
  end while;
end process
