-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)putchar.p	1.2 3/13/90

putChar: using (predefined, terminalIO, terminalInits, unix)
process (initQ: initPutCharQ)

declare
  init: initPutCharIntf;
  fputc: fputc_function;
  putCharQ: putCharQ;
  putChar: putCharIntf;
  file: handle;
  int: int;

begin
  receive init from initQ;
  fputc := init.fputc;
  file := init.file;
  new putCharQ;
  connect init.putChar to putCharQ;
  return init;

  while boolean#'true' repeat
    receive putChar from putCharQ;
    call fputc(putChar.char, file, int);

    if boolean#(int >= int#0) then
      return putChar;
    else
      discard putChar;
    end if;
  end while;
end process
