-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)stdio.pp	1.3 3/13/90

PROCNAME: USING (predefined, unix, errno)

PROCESS ( iport: stdio_server_inport )
DECLARE
 imsg: stdio_server_call;
 unixCall: unixCall_func;
 unixRExternal: read_external_variableFunction;
 stdin: handle;
 stdout: handle;
 stderr: handle;
 r_ret: unixoperand;
 clearerr_inport:clearerr_inport; 
 ctermid_inport:ctermid_inport;  
 cuserid_inport:cuserid_inport;  
 fclose_inport:fclose_inport;   
 fdopen_inport:fdopen_inport;   
 feof_inport:feof_inport;     
 ferror_inport:ferror_inport;   
 fflush_inport:fflush_inport;   
 fgetc_inport:fgetc_inport;    
 fgets_inport:fgets_inport;    
 fileno_inport:fileno_inport;   
 fopen_inport:fopen_inport;    
 fputc_inport:fputc_inport;    
 fputs_inport:fputs_inport;    
 fread_inport:fread_inport;    
 freopen_inport:freopen_inport;  
 fseek_inport:fseek_inport;    
 ftell_inport:ftell_inport;    
 fwrite_inport:fwrite_inport;   
 getc_inport:getc_inport;     
 getchar_inport:getchar_inport;  
 getw_inport:getw_inport;     
 pclose_inport:pclose_inport;   
 popen_inport:popen_inport;    
 putc_inport:putc_inport;     
 putchar_inport:putchar_inport;  
 puts_inport:puts_inport;     
 putw_inport:putw_inport;     
 rewind_inport:rewind_inport;   
 setlinebuf_inport:setlinebuf_inport;
 tmpfile_inport:tmpfile_inport;   
 tmpnam_inport:tmpnam_inport;

BEGIN
  RECEIVE imsg FROM iport;
   /* get what we need to service future calls */
   unixCall := imsg.unixCall;
   unixRExternal := imsg.unixRExternal;
   /* Initialize the return value */
   NEW imsg.stdio; 
   /* the three handles */
   CALL unixRExternal(external_variable#'stdin',r_ret);
   REVEAL r_ret.handle;
   DISSOLVE r_ret.handle INTO imsg.stdio.stdin;
   CALL unixRExternal(external_variable#'stdout',r_ret);
   REVEAL r_ret.handle;
   DISSOLVE r_ret.handle INTO imsg.stdio.stderr;
   CALL unixRExternal(external_variable#'stderr',r_ret);
   REVEAL r_ret.handle;
   DISSOLVE r_ret.handle INTO imsg.stdio.stdout;
#ifndef BLOCKINGIO
   /* Make them non blocking */
   BLOCK 
    DECLARE 
      op: unix!unixoperand;
      ret: unix!unixoperand;
      ops: unix!unixoperand_list;
    BEGIN
     /* stdin */
     NEW ops;
     UNITE op.handle from unix!handle#(COPY of imsg.stdio.stdin);
     INSERT op INTO ops;
     CALL unixCall(syscall#'MakeNotBlock',ops,ret);
     /* stdout */
     NEW ops;
     UNITE op.handle from unix!handle#(COPY of imsg.stdio.stdout);
     INSERT op INTO ops;
     CALL unixCall(syscall#'MakeNotBlock',ops,ret);
     /* stderr */
     NEW ops;
     UNITE op.handle from unix!handle#(COPY of imsg.stdio.stderr);
     INSERT op INTO ops;
     CALL unixCall(syscall#'MakeNotBlock',ops,ret);
    END BLOCK;
#endif BLOCKINGIO

   /* These will be used later to recieve the calls */
   NEW clearerr_inport; 
   NEW ctermid_inport;  
   NEW cuserid_inport;  
   NEW fclose_inport;   
   NEW fdopen_inport;   
   NEW feof_inport;     
   NEW ferror_inport;   
   NEW fflush_inport;   
   NEW fgetc_inport;    
   NEW fgets_inport;    
   NEW fileno_inport;   
   NEW fopen_inport;    
   NEW fputc_inport;    
   NEW fputs_inport;    
   NEW fread_inport;    
   NEW freopen_inport;  
   NEW fseek_inport;    
   NEW ftell_inport;    
   NEW fwrite_inport;   
   NEW getc_inport;     
   NEW getchar_inport;  
   NEW getw_inport;     
   NEW pclose_inport;   
   NEW popen_inport;    
   NEW putc_inport;     
   NEW putchar_inport;  
   NEW puts_inport;     
   NEW putw_inport;     
   NEW rewind_inport;   
   NEW setlinebuf_inport;
   NEW tmpfile_inport;   
   NEW tmpnam_inport;
   /* Connect the return values to the ports we plan to wait on */
   CONNECT imsg.stdio.clearerr TO clearerr_inport; 
   CONNECT imsg.stdio.ctermid TO ctermid_inport;  
   CONNECT imsg.stdio.cuserid TO cuserid_inport;  
   CONNECT imsg.stdio.fclose TO fclose_inport;   
   CONNECT imsg.stdio.fdopen TO fdopen_inport;   
   CONNECT imsg.stdio.feof TO feof_inport;     
   CONNECT imsg.stdio.ferror TO ferror_inport;   
   CONNECT imsg.stdio.fflush TO fflush_inport;   
   CONNECT imsg.stdio.fgetc TO fgetc_inport;    
   CONNECT imsg.stdio.fgets TO fgets_inport;    
   CONNECT imsg.stdio.fileno TO fileno_inport;   
   CONNECT imsg.stdio.fopen TO fopen_inport;    
   CONNECT imsg.stdio.fputc TO fputc_inport;    
   CONNECT imsg.stdio.fputs TO fputs_inport;    
   CONNECT imsg.stdio.fread TO fread_inport;    
   CONNECT imsg.stdio.freopen TO freopen_inport;  
   CONNECT imsg.stdio.fseek TO fseek_inport;    
   CONNECT imsg.stdio.ftell TO ftell_inport;    
   CONNECT imsg.stdio.fwrite TO fwrite_inport;   
   CONNECT imsg.stdio.getc TO getc_inport;     
   CONNECT imsg.stdio.getchar TO getchar_inport;  
   CONNECT imsg.stdio.getw TO getw_inport;     
   CONNECT imsg.stdio.pclose TO pclose_inport;   
   CONNECT imsg.stdio.popen TO popen_inport;    
   CONNECT imsg.stdio.putc TO putc_inport;     
   CONNECT imsg.stdio.putchar TO putchar_inport;  
   CONNECT imsg.stdio.puts TO puts_inport;     
   CONNECT imsg.stdio.putw TO putw_inport;     
   CONNECT imsg.stdio.rewind TO rewind_inport;   
   CONNECT imsg.stdio.setlinebuf TO setlinebuf_inport;
   CONNECT imsg.stdio.tmpfile TO tmpfile_inport;   
   CONNECT imsg.stdio.tmpnam TO tmpnam_inport;
  /* Return the callmessage at the first oportunity */
  RETURN imsg;
  /* Wait on calls forever */
  BLOCK 
  DECLARE
   op: unix!unixoperand;
   ret: unix!unixoperand;
   ops: unix!unixoperand_list;
#ifndef BLOCKINGIO
   pollops: unix!unixoperand_list;
   pollerrno: unix!unixoperand;
   pollflag: boolean;
   auxret: unix!unixoperand;
#endif BLOCKINGIO
  BEGIN 
   WHILE boolean#'true' REPEAT
    /* receive a call */
    SELECT 
     EVENT clearerr_inport
      BLOCK 
       DECLARE 
        clearerr_msg: clearerr_call;
      BEGIN
       RECEIVE clearerr_msg from clearerr_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of clearerr_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'clearerr',ops,ret);
       RETURN clearerr_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT ctermid_inport
      BLOCK 
       DECLARE 
        ctermid_msg: ctermid_call;
      BEGIN
       RECEIVE ctermid_msg FROM ctermid_inport;
       NEW ops;
       UNITE op.buffer FROM buffer#(copy of ctermid_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'ctermid',ops,ret);
       RETURN ctermid_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT cuserid_inport
      BLOCK 
       DECLARE 
        cuserid_msg: cuserid_call;
      BEGIN
       RECEIVE cuserid_msg FROM cuserid_inport;
       NEW ops;
       UNITE op.buffer FROM buffer#(copy of cuserid_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'cuserid',ops,ret);
       RETURN cuserid_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT fclose_inport
      BLOCK 
       DECLARE 
        fclose_msg: fclose_call;
      BEGIN
       RECEIVE fclose_msg from fclose_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of fclose_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'fclose',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
#endif BLOCKINGIO
       RETURN fclose_msg;
#ifndef BLOCKINGIO
       DISCARD pollops;
       DISCARD pollflag;
#endif BLOCKINGIO
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT fdopen_inport
      BLOCK 
       DECLARE 
        fdopen_msg: fdopen_call;
      BEGIN
       RECEIVE fdopen_msg from fdopen_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of fdopen_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'fdopen',ops,ret);
#ifndef BLOCKINGIO
       -- set nonblocking I/O
       NEW ops;
       INSERT unix!unixoperand#(COPY of ret) INTO ops;
       CALL unixCall(syscall#'MakeNotBlock',ops,auxret);
       DISCARD auxret; 
#endif BLOCKINGIO
       REVEAL ret.handle;
       DISSOLVE ret.handle INTO fdopen_msg.ret;
       RETURN fdopen_msg;
       DISCARD ops;
      END BLOCK;
     EVENT feof_inport
      BLOCK 
       DECLARE 
        feof_msg: feof_call;
      BEGIN
       RECEIVE feof_msg from feof_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of feof_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'feof',ops,ret);
       REVEAL ret.boolean;
       DISSOLVE ret.boolean INTO feof_msg.ret;
       RETURN feof_msg;
       DISCARD ops;
      END BLOCK;
     EVENT ferror_inport
      BLOCK 
       DECLARE 
        ferror_msg: ferror_call;
      BEGIN
       RECEIVE ferror_msg from ferror_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of ferror_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'ferror',ops,ret);
       REVEAL ret.boolean;
       DISSOLVE ret.boolean INTO ferror_msg.ret;
       RETURN ferror_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fflush_inport
      BLOCK 
       DECLARE 
        fflush_msg: fflush_call;
      BEGIN
       RECEIVE fflush_msg from fflush_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of fflush_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'fflush',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       RETURN fflush_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT fgetc_inport
      BLOCK 
       DECLARE 
        fgetc_msg: fgetc_call;
      BEGIN
       RECEIVE fgetc_msg from fgetc_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of fgetc_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'fgetc',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO fgetc_msg.ret;
       RETURN fgetc_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fgets_inport
      BLOCK 
       DECLARE 
        fgets_msg: fgets_call;
      BEGIN
       RECEIVE fgets_msg from fgets_inport;
       NEW ops;
       UNITE op.buffer from buffer#(copy of fgets_msg.op1);
       INSERT op INTO ops;
       UNITE op.handle from handle#(copy of fgets_msg.op2);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'fgets',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO fgets_msg.ret;
       RETURN fgets_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fileno_inport
      BLOCK 
       DECLARE 
        fileno_msg: fileno_call;
      BEGIN
       RECEIVE fileno_msg from fileno_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of fileno_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'fileno',ops,ret);
       REVEAL ret.int;
       DISSOLVE ret.int INTO fileno_msg.ret;
       RETURN fileno_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fopen_inport
      BLOCK 
       DECLARE 
        fopen_msg: fopen_call;
      BEGIN
       RECEIVE fopen_msg from fopen_inport;
       NEW ops;
       UNITE op.string from predefined!charstring#(copy of fopen_msg.op1);
       INSERT op INTO ops;
       UNITE op.string from predefined!charstring#(copy of fopen_msg.op2);
       INSERT op INTO ops;
       CALL unixCall(syscall#'fopen',ops,ret);
#ifndef BLOCKINGIO
       -- set for nonblocking I/O
       NEW ops;
       INSERT unix!unixoperand#(COPY of ret) INTO ops;
       CALL unixCall(syscall#'MakeNotBlock',ops,auxret);
       DISCARD auxret; 
#endif
       REVEAL ret.handle;       
       DISSOLVE ret.handle INTO fopen_msg.ret;
       RETURN fopen_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fputc_inport
      BLOCK 
       DECLARE 
        fputc_msg: fputc_call;
      BEGIN
       RECEIVE fputc_msg from fputc_inport;
       NEW ops;
       UNITE op.char from char#(copy of fputc_msg.op1);
       INSERT op INTO ops;
       UNITE op.handle from handle#(copy of fputc_msg.op2);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'putc',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO fputc_msg.ret;
       RETURN fputc_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fputs_inport
      BLOCK 
       DECLARE 
        fputs_msg: fputs_call;
      BEGIN
       RECEIVE fputs_msg from fputs_inport;
       NEW ops;
       UNITE op.string from predefined!charstring#(copy of fputs_msg.op1);
       INSERT op INTO ops;
       UNITE op.handle from handle#(copy of fputs_msg.op2);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'fputs',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO fputs_msg.ret;
       RETURN fputs_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fread_inport
      BLOCK
       DECLARE
        fread_msg: fread_call;
       BEGIN
        RECEIVE fread_msg from fread_inport;
        NEW ops;
        UNITE op.array from array#(copy of fread_msg.op1);
        INSERT op INTO ops;
        UNITE op.handle from handle#(copy of fread_msg.op2);
        INSERT op INTO ops;
#ifndef BLOCKINGIO
        NEW pollops;
        pollflag <- boolean#'true';
	unite ret.int from int#0;
        WHILE (pollflag) REPEAT
         CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
         CALL unixCall(syscall#'fread',ops,ret);
#ifndef BLOCKINGIO
         CALL unixRExternal(external_variable#'errno',pollerrno);
         REVEAL pollerrno.int;
         pollflag <-
	     boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
        END WHILE;
	DISCARD pollflag;
	DISCARD pollops;
#endif BLOCKINGIO
	remove op from o in ops where 
	    (boolean#(integer#(position of o) = integer#0));
	reveal op.array;
	dissolve op.array into fread_msg.op1;
        REVEAL ret.int;
        DISSOLVE ret.int INTO fread_msg.ret;
        RETURN fread_msg;
	DISCARD ops;
      END BLOCK;
     EVENT freopen_inport
      BLOCK 
       DECLARE 
        freopen_msg: freopen_call;
      BEGIN
       RECEIVE freopen_msg from freopen_inport;
       NEW ops;
       UNITE op.string from predefined!charstring#(copy of freopen_msg.op1);
       INSERT op INTO ops;
       UNITE op.string from predefined!charstring#(copy of freopen_msg.op2);
       INSERT op INTO ops;
       UNITE op.handle from handle#(copy of freopen_msg.op3);
       INSERT op INTO ops;
       CALL unixCall(syscall#'freopen',ops,ret);
#ifndef BLOCKINGIO
       -- set nonblocking I/O
       NEW ops;
       INSERT unix!unixoperand#(COPY of ret) INTO ops;
       CALL unixCall(syscall#'MakeNotBlock',ops,auxret);
       DISCARD auxret; 
#endif
       REVEAL ret.handle;
       DISSOLVE ret.handle INTO freopen_msg.ret;
       RETURN freopen_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fseek_inport
      BLOCK 
       DECLARE 
        fseek_msg: fseek_call;
      BEGIN
       RECEIVE fseek_msg from fseek_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of fseek_msg.op1);
       INSERT op INTO ops;
       UNITE op.long from long#(copy of fseek_msg.op2);
       INSERT op INTO ops;
       UNITE op.int from int#(copy of fseek_msg.op3);
       INSERT op INTO ops;
       CALL unixCall(syscall#'fseek',ops,ret);
       REVEAL ret.int;
       DISSOLVE ret.int INTO fseek_msg.ret;
       RETURN fseek_msg;
       DISCARD ops;
      END BLOCK;
     EVENT ftell_inport
      BLOCK 
       DECLARE 
        ftell_msg: ftell_call;
      BEGIN
       RECEIVE ftell_msg from ftell_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of ftell_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'ftell',ops,ret);
       REVEAL ret.long;
       DISSOLVE ret.long INTO ftell_msg.ret;
       RETURN ftell_msg;
       DISCARD ops;
      END BLOCK;
     EVENT fwrite_inport
      BLOCK
       DECLARE
        fwrite_msg: fwrite_call;
       BEGIN
        RECEIVE fwrite_msg from fwrite_inport;
        NEW ops;
        UNITE op.array from array#(copy of fwrite_msg.op1);
        INSERT op INTO ops;
        UNITE op.handle from handle#(copy of fwrite_msg.op2);
        INSERT op INTO ops;
#ifndef BLOCKINGIO
        NEW pollops;
        pollflag <- boolean#'true';
	unite ret.int from int#0;
        WHILE (pollflag) REPEAT
         CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
         CALL unixCall(syscall#'fwrite',ops,ret);
#ifndef BLOCKINGIO
         CALL unixRExternal(external_variable#'errno',pollerrno);
         REVEAL pollerrno.int;
         pollflag <-
	     boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
        END WHILE;
	DISCARD pollflag;
	DISCARD pollops;
#endif BLOCKINGIO
        REVEAL ret.int;
        DISSOLVE ret.int INTO fwrite_msg.ret;
        RETURN fwrite_msg;
	DISCARD ops;
      END BLOCK;
     EVENT getc_inport
      BLOCK 
       DECLARE 
        getc_msg: getc_call;
      BEGIN
       RECEIVE getc_msg from getc_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of getc_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'getc',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO getc_msg.ret;
       RETURN getc_msg;
       DISCARD ops;
      END BLOCK;
     EVENT getchar_inport
      BLOCK 
       DECLARE 
        getchar_msg: getchar_call;
      BEGIN
       RECEIVE getchar_msg from getchar_inport;
       NEW ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'getchar',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO getchar_msg.ret;
       RETURN getchar_msg;
      END BLOCK;
     EVENT getw_inport
      BLOCK 
       DECLARE 
        getw_msg: getw_call;
      BEGIN
       RECEIVE getw_msg from getw_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of getw_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'getw',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO getw_msg.ret;
       RETURN getw_msg;
       DISCARD ops;
      END BLOCK;
     EVENT pclose_inport
      BLOCK 
       DECLARE 
        pclose_msg: pclose_call;
      BEGIN
       RECEIVE pclose_msg from pclose_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of pclose_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'pclose',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       RETURN pclose_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT popen_inport
      BLOCK 
       DECLARE 
        popen_msg: popen_call;
      BEGIN
       RECEIVE popen_msg from popen_inport;
       NEW ops;
       UNITE op.string from predefined!charstring#(copy of popen_msg.op1);
       INSERT op INTO ops;
       UNITE op.string from predefined!charstring#(copy of popen_msg.op2);
       INSERT op INTO ops;
       CALL unixCall(syscall#'popen',ops,ret);
#ifndef BLOCKINGIO
       -- set nonblocking I/O
       NEW ops;
       INSERT unix!unixoperand#(COPY of ret) INTO ops;
       CALL unixCall(syscall#'MakeNotBlock',ops,auxret);
       DISCARD auxret; 
#endif
       REVEAL ret.handle;
       DISSOLVE ret.handle INTO popen_msg.ret;
       RETURN popen_msg;
       discard ops;
      END BLOCK;
     EVENT putc_inport
      BLOCK 
       DECLARE 
        putc_msg: putc_call;
      BEGIN
       RECEIVE putc_msg from putc_inport;
       NEW ops;
       UNITE op.char from char#(copy of putc_msg.op1);
       INSERT op INTO ops;
       UNITE op.handle from handle#(copy of putc_msg.op2);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'putc',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO putc_msg.ret;
       RETURN putc_msg;
       DISCARD ops;
      END BLOCK;
     EVENT putchar_inport
      BLOCK 
       DECLARE 
        putchar_msg: putchar_call;
      BEGIN
       RECEIVE putchar_msg from putchar_inport;
       NEW ops;
       UNITE op.char from char#(copy of putchar_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'putchar',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO putchar_msg.ret;
       RETURN putchar_msg;
       DISCARD ops;
      END BLOCK;
     EVENT puts_inport
      BLOCK 
       DECLARE 
        puts_msg: puts_call;
      BEGIN
       RECEIVE puts_msg from puts_inport;
       NEW ops;
       UNITE op.string from predefined!charstring#(copy of puts_msg.op1);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'puts',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO puts_msg.ret;
       RETURN puts_msg;
       DISCARD ops;
      END BLOCK;
     EVENT putw_inport
      BLOCK 
       DECLARE 
        putw_msg: putw_call;
      BEGIN
       RECEIVE putw_msg from putw_inport;
       NEW ops;
       UNITE op.int from int#(copy of putw_msg.op1);
       INSERT op INTO ops;
       UNITE op.handle from handle#(copy of putw_msg.op2);
       INSERT op INTO ops;
#ifndef BLOCKINGIO
       NEW pollops;
       pollflag <- boolean#'true';
       unite ret.int from int#0;
       WHILE (pollflag) REPEAT
        CALL unixCall(syscall#'ClearErrno',pollops,ret);
#endif BLOCKINGIO
        CALL unixCall(syscall#'putw',ops,ret);
#ifndef BLOCKINGIO
        CALL unixRExternal(external_variable#'errno',pollerrno);
        REVEAL pollerrno.int;
        pollflag <-
	    boolean#(pollerrno.int = int#(CONVERT of errno#'EWOULDBLOCK'));
       END WHILE;
       DISCARD pollflag;
       DISCARD pollops;
#endif BLOCKINGIO
       REVEAL ret.int;
       DISSOLVE ret.int INTO putw_msg.ret;
       RETURN putw_msg;
       DISCARD ops;
      END BLOCK;
     EVENT rewind_inport
      BLOCK 
       DECLARE 
        rewind_msg: rewind_call;
      BEGIN
       RECEIVE rewind_msg from rewind_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of rewind_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'rewind',ops,ret);
       RETURN rewind_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT setlinebuf_inport
      BLOCK 
       DECLARE 
        setlinebuf_msg: setlinebuf_call;
      BEGIN
       RECEIVE setlinebuf_msg from setlinebuf_inport;
       NEW ops;
       UNITE op.handle from handle#(copy of setlinebuf_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'setlinebuf',ops,ret);
       RETURN setlinebuf_msg;
       DISCARD ops;
       DISCARD ret;
      END BLOCK;
     EVENT tmpfile_inport
      BLOCK 
       DECLARE 
        tmpfile_msg: tmpfile_call;
      BEGIN
       RECEIVE tmpfile_msg from tmpfile_inport;
       NEW ops;
       CALL unixCall(syscall#'tmpfile',ops,ret);
       REVEAL ret.handle;
       DISSOLVE ret.handle INTO tmpfile_msg.ret;
       RETURN tmpfile_msg;
       DISCARD ops;
      END BLOCK;
     EVENT tmpnam_inport
      BLOCK 
       DECLARE 
        tmpnam_msg: tmpnam_call;
      BEGIN
       RECEIVE tmpnam_msg FROM tmpnam_inport;
       NEW ops;
       UNITE op.buffer FROM buffer#(copy of tmpnam_msg.op1);
       INSERT op INTO ops;
       CALL unixCall(syscall#'tmpnam',ops,ret);
       REVEAL ret.int;
       DISSOLVE ret.int INTO tmpnam_msg.ret;
       RETURN tmpnam_msg;
       DISCARD ops;
      END BLOCK;
    OTHERWISE
    END SELECT;
   END WHILE;
  END BLOCK;
END PROCESS
