/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)stdnil.h	1.4 3/13/90 */

#ifndef stdnil_included

/******************************************************************************
 * Basic Type Defs
 *****************************************************************************/

typedef unsigned int counter;	/* a counter from 0 to MAXUINT */

typedef short flag;		/* a boolean flag -- use as little as */
				/*  possible for a bit. */

/* typedef int void;               for c compilers without voids, do this */

#undef TRUE
#undef FALSE

#define TRUE -1
#define FALSE 0
#define SUCCESS -1
#define FAILURE 0

/* specific values expected of XDR routines */
#define XDR_OK 1
#define XDR_FAIL 0
/* XDR return value type */
typedef int xdr_status;

typedef int status;		/* returns SUCCESS or FAILURE */

#define nil 0

/*
 * less confusing comparison and logical operators help us avoid some common
 * C bugs, like "if (x = 3)".
 */

#define is ==
#define isnt !=
#define and &&
#define or ||
#define not !

#define until(cond) 	    while(not(cond))
#define ever	    	    ;;

#define min(x,y)   ((x) < (y) ? (x) : (y))
#define max(x,y)   ((x) > (y) ? (x) : (y))

#endif
#define stdnil_included
