-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)terminalinits.d	1.2 3/13/90

terminalInits: using (predefined, unix, terminalIO)
definitions

  initPutStringIntf: callmessage (
    fputs: fputs_function,
    file: handle,
    putString: putStringFunc
  ) constant (fputs, file)
    exit { full };

  initPutStringQ: inport of initPutStringIntf { init(fputs), init(file) };
  initPutStringFunc: outport of initPutStringQ;


  initGetStringIntf: callmessage (
    fgetc: fgetc_function,
    file: handle,
    getString: getStringFunc
  ) constant (fgetc, file)
    exit { full };

  initGetStringQ: inport of initGetStringIntf { init(fgetc), init(file) };
  initGetStringFunc: outport of initGetStringQ;


  initGetCharIntf: callmessage (
    fgetc: fgetc_function,
    file: handle,
    getChar: getCharFunc
  ) constant (fgetc, file)
    exit { full };

  initGetCharQ: inport of initGetCharIntf { init(fgetc), init(file) };
  initGetCharFunc: outport of initGetCharQ;


  initPutCharIntf: callmessage (
    fputc: fputc_function,
    file: handle,
    putChar: putCharFunc
  ) constant (fputc, file)
    exit { full };

  initPutCharQ: inport of initPutCharIntf { init(fputc), init(file) };
  initPutCharFunc: outport of initPutCharQ;

end definitions
