-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)terminalio.d	1.2 3/13/90

terminalIO: using (predefined)
definitions

  terminalFunctions: record (
    putString: putStringFunc,	-- print a string
    putLine: putStringFunc,	-- print a string plus a newline
    getString: getStringFunc,	-- read a string 
    putChar: putCharFunc,	-- print a character
    getChar: getCharFunc	-- get a character 
  );

-- putString: prints a string on the virtual terminal.  There are no
--  specific exceptions, since the terminal shouldn't disappear while the
--  application is running.

  putStringIntf: callmessage (
    string: charstring
  ) constant (string)
    exit { init(string) };

  putStringQ: inport of putStringIntf { init(string) };
  putStringFunc: outport of putStringQ;

-- putChar: prints a character on the virtual terminal.  There are no
--  specific exceptions, since the terminal shouldn't disappear while the
--  application is running.

  putCharIntf: callmessage (
    char: char
  ) constant (char)
    exit { init(char) };

  putCharQ: inport of putCharIntf { init(char) };
  putCharFunc: outport of putCharQ;

-- getString: returns strings from the virtual terminal until there are none,
--  at which point it raises endOfInput.  After this, it may discard the inport
--  so that the caller will get a Disconnected exception if he keeps trying.

  getStringIntf: callmessage (
    string: charstring
  ) exit { init(string) }
    exception endOfInput { };

  getStringQ: inport of getStringIntf { };
  getStringFunc: outport of getStringQ;

-- getChar: returns characters from the virtual terminal until there aren't any
--   more, at which point it raises endOfInput.  It is only obliged to do this
--   once; after raising the exception the port is no longer "usable" and
--   calls may result in a Disconnected exception.

  getCharIntf: callmessage (
    char: char
  ) exit { init(char) }
    exception endOfInput { };

  getCharQ: inport of getCharIntf { };
  getCharFunc: outport of getCharQ;

end definitions
