/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: profile.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)profile.ch	1.6 3/21/90";
#endif

#include <stdio.h>
#include <signal.h>

#include "cherm.h"

#include "interpform.cd"
#include "profile.cd"

#define PROFFLAG "HPROF"
#define PROF_ENV_NAME "HPROFFILE"
#define PROFINT "HPROFINTERVAL"
#define PROF_ENV_DEFAULT "hprof"

extern pcb *current;

int profile_level;		/* controls profiling (just 0 or 1 now) */
static int samples, otherhits, chits;

lobject(Proftable);

void
init_prof()
{
#ifdef TRACE
  void alarmhandler();
  char *getenv();

  char *profstring;
  int interval;


  profstring = getenv(PROFFLAG);

  if (profstring) 
      profile_level = atoi(profstring);
  else
    profile_level = 0;

  if (prof_level(1))
    if (!avl_new_table(Proftable, firstelem_key)) {
	profile_level = 0;	/* suppress profiling if table */
	set_bottom(Proftable);	/* couldn't be allocated */
	return;
    }

  if (prof_level(2)) {
      interval = getenv(PROFINT) ? atoi(getenv(PROFINT)) : 100000;
      current = nil;
      signal(SIGALRM, alarmhandler);

#ifndef sgi
      (void) ualarm(interval, interval);
#else
      nilerror("init_prof", "timer based profiling not available")
#endif

      samples = chits = otherhits = 0;
  }
#endif
}


status
prof_level(l)
int l;
{
  return(profile_level >= l);
}


void
set_prof_level(l)
int l;
{
    profile_level = l;
    if (prof_level(1) && isbottom(Proftable))
      if (!avl_new_table(Proftable, firstelem_key))
	profile_level = 0;	/* suppress profiling if table */
				/* couldn't be allocated */
}


void
create_profrec(proc)
pcb *proc;
{
#ifdef TRACE
    lobject(Profrec);
    lobject(Newinfo);
    lobject(Zero);
    lobject(One);
    objectp Liprog;
    objectp Recptr;
    int i;

    
    Liprog = & proc->prog->data[program__LI_PROGRAM];

    set_bottom(Profrec);
    set_bottom(Newinfo);

    if (h_lookup(Profrec, Proftable, Liprog@Id, nil) is NotFound) {
	if (new_record(Profrec, profile) isnt Normal) goto cleanup;
	if (copy(Profrec@Id, Liprog@Id) isnt Normal) goto cleanup;
	if (copy(Profrec@profile__name, Liprog@prog__name) isnt Normal) 
	  goto cleanup;
	(void) ilit(Profrec@profile__creates, 1);

	if (new_record(Newinfo, integer_pair) isnt Normal) goto cleanup;
	(void) ilit(Newinfo@integer_pair__int_one, size_of(Liprog@prog__code));
	(void) ilit(Newinfo@integer_pair__int_two, 1);
	if (!vec_new_table(Profrec@profile__counts, Newinfo)) goto cleanup;
	discard(Newinfo);

	for (i = 0; i < size_of(Liprog@prog__code); i++) {
	    ilit(Zero, 0);
	    if (insert(Profrec@profile__counts, Zero) isnt Normal)
	      goto cleanup;
	}

	Recptr = Profrec@profile__counts;
	if (insert(Proftable, Profrec) isnt Normal) goto cleanup;
    }
    else {
	(void) ilit(One, 1);
	(void) iadd(Profrec@profile__creates, Profrec@profile__creates, One);
	Recptr = Profrec@profile__counts;
    }

    proc->profile = Recptr->value.table->tbls[ORDER_TBL].rep.vec->elements;
    return;

  cleanup:
    (void) discard(Profrec);
    (void) discard(Newinfo);
    proc->profile = nil;
#endif
}


void
write_profile()
{
#ifdef TRACE
    lobject(Proffile);		/* dubious punning */
    char *profenv;

    profenv = getenv(PROF_ENV_NAME);

    if (chs_lit(Proffile, profenv ? profenv : PROF_ENV_DEFAULT)) {
	write(Proftable, Proffile);
	discard(Proffile);
    }

    if (prof_level(2))
      fprintf(stderr, "Samples: %d; C Processes: %d; Non-Hermes: %d\n",
	      samples, chits, otherhits);
#endif
}



void 
alarmhandler(sig, code, scp, addr)
int sig, code;
struct sigcontext *scp;
char *addr;
{
#ifdef TRACE
    samples++;

    if (current) 
      if (current->profile) 
/*	current->profile[current->ip].integer++ */ ;
      else
	chits++;
    else
      otherhits++;
#endif
}
