-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)cache.pp	1.5 3/13/90

cache: using (predefined, common, main, findfile, initfindfile, objectIO, 
    load, objectCache, programCache, stdenv, pathLoad, pathReadObj, root,
    unixstat)
process (initQ: main_Q)

declare
  init: main_Intf;
  capability: polymorph;
  stat: statMtimeFunc;
  initCache: objectcache!initCacheFunc;
  initProgramCache: programcache!initCacheFunc;
  nonStd: stdenv;
  pathinit: initfindfile!initFindFileFn;
  defpathfinder: findfile!findfile_func;
  syspathfinder: findfile!findfile_func;
  pathloadfile: charstring;
  pathloadinit: pathload_init_func;
  pathreadinit: pathreadobj_init_func;
  args: common!charstringList;
  string: charstring;
  progname: charstring;
  main: main!main_func;

-- definitions for getpaths.pp include file
  bindir: charstring;
  syspath: charstring;
  defpath: charstring;

begin
  receive init from initQ;
  
  -- get file stat function 
  call init.CLoader(charstring#"File Modification Time", capability);
  unwrap stat from capability { init };

-- create the modified stdenv with caching versions of direct operations
-- (read, write, load, store)
  nonStd := init.std;

  initCache <- objectCache!initCacheFunc#(procedure of program#(
	init.std.pathload(charstring#"objectcache")));
  call initCache(nonStd.ReadObj, nonStd.writeObj, stat);

  initProgramCache <- programCache!initCacheFunc#(procedure of program#(
	init.std.pathload(charstring#"programcache")));
  call initProgramCache(nonStd.load, nonStd.Store, stat);

-- now create the caching versions of the indirect operations
-- (pathReadObj, libWriteObj, pathLoad, libStore)

-- this figures out where to get object files, based on environment
-- path variables
#define ENVIRON init.environ
#include "../../hermes/getpaths.pp"

-- create the pathfinder
  pathinit <- initFindFileFn#(procedure of program#(
    init.std.pathLoad(charstring#"findfile")));
  syspathfinder <- findfile_func#(
	pathinit(init.unix.access, nonStd.getCwd, syspath));
  defpathfinder <- findfile_func#(
	pathinit(init.unix.access, nonStd.getCwd, defpath));

-- load the pathloader
  pathloadinit <- pathload_init_func#(create of 
		  program#(init.std.pathload(charstring#"pathload")));
  nonStd.pathload <- load_func#(pathloadinit(nonStd.load, syspathfinder));

-- load the pathreader
  pathreadinit <- pathreadobj_init_func#(create of 
		  program#(init.std.pathload(charstring#"pathreadobj")));
  nonStd.pathreadobj <- readobject_func#(pathreadinit(nonStd.readobj, 
		  defpathfinder));

------------------------------------------------------------------------------

-- now we've created the special version of stdenv, nonStd, with all the 
-- object and program IO functions replaced by caching versions.
-- now just invoke the desired subprogram.

  args := init.argv;
  remove string from arg in args where (boolean#(integer#(position of arg) =
    integer#1));

  progname <- charstring#(arg in args where (boolean#(integer#(
	position of arg) = integer#1)));

  main <- main_func#(create of program#(nonStd.pathLoad(progname)));

  call main(args, init.environ, nonStd, init.unix, init.CLoader);

  return init;

end process
