-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: linkserver.d
-- Author: Andy Lowry
-- SCCS Info: @(#)linkserver.d	1.2 3/13/90

-- Interface for a process that sets up to service link requests from
-- remote Hermes interpreters.  Pass a system-level resource manager
-- capabilities record.  That record will be copied and handed out to
-- all generic requests on the link port, which is established by the
-- linkServer process

linkServer: using (distributed, sysRManager)

definitions
  
  linkServer: callmessage (
    sysRM: sysRManager,
    setLink: setLinkingPortFn	-- capability to establish outport for links
  )
  constant (sysRM, setLink)
  exit {full};
  
  linkServerQ: inport of linkServer {full};
  linkServerFn: outport of linkServerQ;
  
end definitions

