-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rshell.p
-- Author: Andy Lowry
-- SCCS Info: @(#)rshell.p	1.2 3/13/90

-- This process assembles its args into a command line and submits the
-- command line for execution by an rshell server

rShell: using (rShell, rMain, common, stdio)

process (Q: rMainQ)
  
declare
  args: rMain;
  rShell: rShellFn;
  argv: charStringList;
  cmdLine: charString;
  stdin: stdin;
  stdout: stdout;
begin
  receive args from Q;
  
  -- get capability to a remote shell server
  unwrap rShell from args.rm.get("remote shell", "") {init};

  -- assemble a command line from our argument vector
  unwrap argv from args.rm.get("argv", "") {init};
  new cmdLine;
  for arg in argv where (position of arg >= 2) inspect
    merge arg | " " into cmdLine;
  end for;
  
  -- get our stdin and stdout... remote process will use them
  unwrap stdin from args.rm.get("stdin", "stdio") {
    init, init(getChar), init(getString)};
  unwrap stdout from args.rm.get("stdout", "stdio") {
    init, init(putChar), init(putString), init(putLine)};
  
  -- invoke the command
  call rShell(cmdLine, stdin, stdout);
  return args;
  
end process
