-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getuses.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getuses.d	1.2 3/13/90"
-- description:  interfaces used by getuses
getuses: using(make,common,unix,findfile,terminalio,load)
definitions

-- getusesFn is passed the name of an object O and returns the names of
-- objects O1,..,On that it depends upon (i.e., O1,..,On must be up-to-date
-- or remade before one can make O)
getusesIntf: callmessage (
   name: charstring,
   uses: make!charstringSet
) exit {full}
  exception getusesfailure {init(name)};
getusesQ: inport of getusesIntf {init(name)};
getusesFn: outport of getusesQ;

-- setupGetusesIntf is passed some capabilities and returns a getuses
-- function
setupGetusesIntf: callmessage (
   pathload: load!load_func,
   unix: unix!unix,
   findfileDO: findfile!findfile_func,
   findfilePO: findfile!findfile_func,
   getuses: getusesFn
) constant(pathload, unix, findfileDO, findfilePO)
  exit {full}
  minimum {full(pathload), full(unix), full(findfileDO), full(findfilePO)};
setupGetusesQ: inport of setupGetusesIntf {full(pathload),full(unix),
                  full(findfileDO), full(findfilePO)};
setupGetusesService: outport of setupGetusesQ;

-- getlineIntf is an interface to a group of functions that take
-- a getstring function and return a string.  For example, a particular
-- function using this interface may get the next "line" from the file,
-- filter out leading spaces, and return the resultant string.  
getlineIntf: callmessage (
   getstring: terminalio!getStringFunc,
   s: charstring
) constant(getstring)
  exit{full}
  minimum {full(getstring)}
  exception endOfInput {full(getstring)};  
getlineQ: inport of getlineIntf {full(getstring)};
getlineFunc: outport of getlineQ;

-- getnextuse is given a string representing a "using" or "linking" list
-- and a pos in the string.  It returns the next "use" or "link" in the 
-- list. 
getNextUseIntf: callmessage (
   string: charstring,
   pos: integer,
   substring: charstring
) constant(string)
  exit {full}
  exception noUse {full(string), init(pos)};
getNextUseQ: inport of getNextUseIntf {full(string), init(pos)};
getNextUseFunc: outport of getNextUseQ;

-- CharPos(c,s) returns the position of char c in string s.  
-- Returns -1 if not found
  CharPosIntf: callmessage (
    c: char,			-- char to search for
    s: charstring,		-- string to search in
    pos: integer
  ) constant(c,s)
    exit { full };
CharPosQ: inport of CharPosIntf { full(c), full(s) };
CharPosFunc: outport of CharPosQ;

-- SubstringIntf is used by RightString(s,pos) and by LeftString(s,pos).  
-- The latter returns the substring to the left of position pos and the
-- former returns the substring starting at position pos and to its right.  
-- If pos < 0 then LeftString(s,pos) returns the null string. 
-- If pos > |s| then RightString(s,pos) returns the null string. 
SubstringIntf: callmessage(
    s: charstring,
    pos: integer,
    sub: charstring
  ) constant(s,pos)
    exit {full};
SubstringQ: inport of SubstringIntf {full(s), init(pos)};
SubstringFunc: outport of SubstringQ;

end definitions
