-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: timestamp.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)timestamp.d	1.2 3/13/90"
-- description: 
-- this module contains definitions for a timestamp module, which
-- receives requests for the timestamp of a Hermes object.
-- It finds the timestamp of the object and returns it.  It also stores
-- the timestamp in a cache so future requests for the same object
-- can be answered by a cache lookup.
timestamp: using(unix,unixstat)
definitions

tsrequest: callmessage(
  name: charstring,
  result: unix!long  -- representation of a unix timestamp
  ) constant(name)
    exit {full}
    minimum {init(name)};
tsrequestQ: inport of tsrequest {init(name)};
tsrequestFn: outport of tsrequestQ;

-- timestampInitFn receive two capabilities and returns a timestamp request
-- function
timestampInit: callmessage(
   stat: unixstat!statMtimeFunc,
   access: unix!access_func,
   tsFn: tsrequestFn  
  ) constant(access)
    exit { full(access), full(tsFn) };
timestampInitQ: inport of timestampInit { full(stat), full(access) };
timestampInitFn: outport of timestampInitQ;

timestampentry: record(
  name: charstring,
  timestamp: unix!long  -- representation of a unix timestamp
  );

tscache: table of timestampentry {full} keys(name);

end definitions
