-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pcomshell.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)pcomshell.p	1.3 3/13/90"
-- recieves a process name + env and returns the function to invoke pcom on that name
pcomshell: using(main,common,root,stdenv,unix,cload,make,getdep)
process(ActionInitQ: ActionInitq)

declare
ActionInitArgs: ActionInitIntf;
pcom: main!main_Func;
q: ActionQ;
fn: ActionFunc;
args: ActionIntf;
environ: root!environ;
std: stdenv!stdenv;
unix: unix!unix;
CLoader: cload!CLoadFn;
argv: common!charstringList;

begin
receive ActionInitArgs from ActionInitQ;
pcom <- create of ActionInitArgs.std.pathload("pcom");

environ := ActionInitArgs.environ;
std := ActionInitArgs.std;
unix := ActionInitArgs.unix;
CLoader := ActionInitArgs.CLoader;
new argv; 

-- insert the command line into the arguments list  (hermi pcom <name>)i
insert "hermi" into argv;  
insert "pcom" into argv;
insert copy of ActionInitArgs.name into argv; 

new q;
connect fn to q;
ActionInitArgs.action <- fn;
return ActionInitArgs;

-- wait for call 
   receive args from q;
block begin
   call pcom(argv,environ,std,unix,CLoader);
   args.made <- 'true';  -- compilation success
on (Disconnected)    -- if pcom bombs out
   args.made <- 'false'; -- compilation failure
end block;

return args;
end process
