-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: wrapargs.p
-- Author: Andy Lowry
-- SCCS Info: @(#)wrapargs.p	1.2 3/13/90

-- This process takes a program name and an argument string vector,
-- and returns an rmain capability that will eventually cause the
-- naemd program to be invoked with its arguments available via
-- resource "argv".

wrapArgs:
using (pshell, rmanager, common, rmain, load)
linking (ac_none)

process (Q: wrapArgsQ)
  
declare
  args: wrapArgs;
  proc: rmainFn;
  wrapQ: rmainQ;
  argv: charStringList;
begin
  receive args from Q;

  block declare
    pathLoad: load_func;
  begin
    -- load and wrap the application procedure, and save the arg vector
    unwrap pathLoad from args.rm.get("pathLoad", "") {init};
    proc <- create of pathLoad(args.name);
    new wrapQ;
    connect args.wrappedProc to wrapQ;
    argv := args.argv;
    return args;
  on (getResource.notFound, getResource.accessDenied, polymorphMismatch,
      load_intf.file_Not_Found, interfaceMismatch)
    return args exception Failure;
    exit done;
  end block;
  
  -- when a call comes in on the wrapper, install the argv resource
  -- and then forward the callmessage on to the real application process
  block declare
    msg: rmain;
    resource: polymorph;
    ac_none: accessFn;
  begin
    receive msg from wrapQ;
    block begin
      ac_none <- create of process ac_none;
    on (others)
      discard msg;
      exit done;
    end block;
    wrap argv as resource;
    call msg.rm.post("argv", resource, ac_none);
    send msg to proc;
  end block;

on exit(done)

end process
