-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)copyable.p	1.3 3/13/90 
-- checks that the argument is a copyable type (i.e., all types except
-- call messages, inports, & types that contain them) 

copyable: using(type)
PROCESS(CopyQ: CopyableQueue)
DECLARE
  CopyM: CopyableMessage;
  Copyable: CopyableCapa;
BEGIN
  RECEIVE CopyM FROM CopyQ;
  block begin
    insert copy of CopyM.argument into CopyM.encounteredTypes;
  on(duplicatekey)
    exit return_true;
  end block;

  INSPECT definitions_module IN CopyM.definitions[CopyM.argument.moduleid]
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  [CopyM.argument.typeid]
    BEGIN
      SELECT CASE OF type_def.specification
      -- true cases:
      WHERE('nominaltype') EXIT return_true;
      WHERE('integertype') EXIT return_true;
      WHERE('booleantype') EXIT return_true;
      WHERE('enumerationtype') EXIT return_true;
      WHERE('realtype')  EXIT return_true;
      WHERE('outporttype') EXIT return_true;
      WHERE('polymorphtype') EXIT return_true;

      -- false cases:
      WHERE('callmessagetype') EXIT return_false;
      WHERE('inporttype') EXIT return_false;

      -- recursive cases:
      WHERE('recordtype')
	Copyable <- procedure of currentprogram;
	FOR component IN type_def.component_declarations[] INSPECT
	  -- recursively call Copyable to determine if component type
	  -- is a copyable type  
	  IF NOT Copyable(component.type, CopyM.definitions,
	      CopyM.encounteredTypes) then
	    exit return_false;
	  END IF ;
	END FOR;
	EXIT return_true;
      WHERE('varianttype')
	Copyable <- procedure of currentprogram;
	FOR component IN type_def.component_declarations[] INSPECT
	  -- recursively call Copyable to determine if component type
	  -- is a copyable type
	  IF NOT Copyable(component.type, CopyM.definitions,
	      CopyM.encounteredTypes) then
	    EXIT return_false;    	    	    	
	  END IF ;
	END FOR;
	EXIT return_true;
      WHERE('tabletype') 
	REVEAL type_def.specification.table_info; 
	Copyable <- procedure of currentprogram;
	-- recursively call Copyable to determine if element type is a
	-- copyable type   
	IF NOT Copyable(type_def.specification.table_info.element_type,
	    CopyM.definitions, CopyM.encounteredTypes) then
	  EXIT return_false;
	ELSE
	  EXIT return_true;
	END IF ;
      OTHERWISE  -- can't occur since all cases already dealt with
	exit cantHappen;
      END SELECT;
    END INSPECT;
  END INSPECT;
ON EXIT (return_true)
  CopyM.result <- 'true';
  RETURN CopyM;
ON EXIT (return_false)
  CopyM.result <- 'false';
  RETURN CopyM;
ON EXIT (cantHappen)
END process
