-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: popolyts.p
-- Author: Rob Strom
-- SCCS Info: @(#)popolyts.p	1.3 3/13/90

popolyts : USING( tscheck, Predefined  ) PROCESS (PostPolymorphTSInit : DeterminePostconditionInport )
-- Postcondition for unwrap
-- Algorithm:  
-- Substitute the destination object into the formal typestate
-- These attributes are to be added to the typestate
  DECLARE
    FP: DeterminePostconditionCall ;
  BEGIN
    RECEIVE FP FROM PostPolymorphTSInit ;
    REVEAL FP.Statement.Qualifier.Formal_Typestate;
    MERGE FP.Services.Substitute(FP.Services, FP.Statement.Operands[FP.Affected_Operands[0]], FP.Statement.Qualifier.Formal_Typestate) INTO FP.NormalPostcondition.Adds;
    RETURN FP;
  END PROCESS
