-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: prereturn.p
-- Author: Rob Strom
-- SCCS Info: @(#)prereturn.p	1.2 3/13/90

-- prereturn:  Precondition for RETURN
-- Algorithm:
-- 1. Get formal typestate.  Exit typestate if no exception,
--    else exception typestate if exception specified.
-- 2. Substitute callmessage object to get required attributes. (include INIT(CM))
-- 3. Forbidden attributes are any higher attributes
prereturn : USING( tscheck, Predefined ) PROCESS ( PreLowestPostconditionInit : DeterminePreconditionInport)
  DECLARE
    FP: DeterminePreconditionCall ;
    CMType: Typename; -- the variant's type
    FormalTS: Formal_Typestate; -- the call postcondition formal typestate
    PostTypestate: Typestate; -- the call postcondition typestate
    HigherAttributes: Typestate; -- any other attributes of CM
    
  BEGIN
    RECEIVE FP FROM PreLowestPostconditionInit ;
    INSPECT Obj IN FP.Statement.Operands WHERE(POSITION OF Obj = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        CMType <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, Obj);
	INSPECT Module IN FP.Definitions WHERE(Module.Id = CMType.ModuleId)
	  BEGIN
	    INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = CMType.TypeId)
	      BEGIN
		-- 1.
		REVEAL Definition.Specification.Callmessage_Info; 
		BLOCK
		  BEGIN
		    REVEAL FP.Statement.Qualifier.ExceptionId;
		    INSPECT ExceptionSpec IN Definition.Specification.Callmessage_Info.Exception_Specifications WHERE(ExceptionSpec.ExceptionId = FP.Statement.Qualifier.ExceptionId)
		      BEGIN
		        FormalTS := ExceptionSpec.Post_Typestate;
		      END INSPECT; 
		  ON (CaseError)
		    FormalTS := Definition.Specification.Callmessage_Info.Normal;
		  END BLOCK;
		-- 2.
	        CALL FP.Services.Substitute(FP.Services, Obj, FormalTS, PostTypestate);
		BLOCK
		  BEGIN
		    INSERT (EVALUATE InitDest : Attribute FROM
		      NEW InitDest;
		      NEW InitDest.Objects;
		      UNITE InitDest.Name.Init FROM EVALUATE Nothing: Empty FROM END;
		      INSERT COPY OF Obj INTO InitDest.Objects;
		      END) INTO PostTypestate;
		  ON (DuplicateKey)
		  END BLOCK;
		-- 3.
		CALL FP.Services.Involving(FP.CurrentTS, Obj, PostTypestate, HigherAttributes);
		MERGE PostTypestate INTO FP.Required;
		MERGE HigherAttributes INTO FP.Forbidden; 
	      END INSPECT;
	  END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
