-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
openwindow: using (predefined,common,wininternal,cwindow,fdhandlers,unix)
  process (Q: openWindowQ)
  declare
    args: openWindow;
    cwindow: cwindowFn;
    readinit: readInitFn;
    writeinit: writeInitFn;
    closeinit: closeInitfn;
    in: unix!handle;
    out: unix!handle;
    label: charstring;
    options: charstring;
    poly: common!polymorph;
  begin
    -- Let's do it:
    receive args from Q;
    label := args.label;
    options := args.options;
    -- print charstring#"Opening a new window:";
    -- print label;

    poly <- args.cload("Window");
    unwrap cwindow from poly {init};
    call cwindow(label,options,in,out);

    poly <- args.cload("FD Close");
    unwrap closeinit from poly {init};
    args.close <- closeinit(in,out);

    poly <- args.cload("FD Read");
    unwrap readinit from poly {init};
    args.read <- readinit(in);

    poly <- args.cload("FD Write");
    unwrap writeinit from poly {init};
    args.write <- writeinit(out);

    return args;
 end process

