-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
readwin: using (predefined,common,wininternal,fdhandlers,terminalio)
process (Q: readHandlerQ)
declare
  args: readHandler;
  read: readFn;
  close: signalPort;
  shutdown: signalQ;
  getCharQ: getCharQ;
  getStringQ: getStringQ;
  buffer: charstring;
  empty: empty;
begin
  -- servers type process
  receive args from Q;
  read <- args.read;
  close <- args.close;
  shutdown <- args.shutdown;
  new getCharQ;
  connect args.getChar to getCharQ;
  new getStringQ;
  connect args.getString to getStringQ;
  return args;
  new buffer;
  
  while (boolean#'true') repeat
    -- service the next call
    select
    event getCharQ
      -- we need a character
      block declare
	getChar: getCharIntf;
	s: charstring;
      begin
	receive getChar from getCharQ;
	if (exists of buffer[0]) then
	  remove getChar.char from buffer[0];
	  return getChar;
	else
	  block begin
	    if (read(s)) then
	      merge s into buffer;
	      remove getChar.char from buffer[0];
	      return getChar;
	    else
	      return getChar exception endOfInput;
	      exit ReadError;
	    end if;   
	  on (disconnected, read.discarded)
	    return getChar exception endOfInput;
	    exit ReadError;
	  end block;
	end if;
      end block;
    event getStringQ
      -- we need a string (newline terminated)
      block declare
	getString: getStringIntf;
	eol: integer;
	s: charstring;
	nl: char;
      begin
	receive getString from getStringQ;
	while (not exists of c in buffer where (c='NL')) repeat
	  block begin
	    if (read(s)) then
	      merge s into buffer;
	    else
	      return getString exception endOfInput;
	      exit ReadError;
	    end if;
	  on (disconnected, read.discarded)
	    return getString exception endOfInput;
	    exit ReadError;
	  end block;
	end while;
	inspect c in buffer where (c='NL') begin
	  eol := position of c;
	end inspect;
	for c in buffer where (c='NL') inspect
	  if ((position of c)<eol) then
	    eol := position of c;
	  end if;
	end for;
	extract getString.string from c in buffer
	    where ((position of c)<eol);
	remove nl from c in buffer[0];
	return getString;
      end block;
    event shutdown
      receive empty from shutdown;
      -- Killed by closewin... act like we hit EOF
      exit ReadError;
    otherwise
      -- this can never be executed
    end select;
  end while;
  
on exit(ReadError)
  -- shutdown the window (it may already have been shut down, but
  -- that's ok)
  block begin
    send empty to close;
  on (disconnected)
  end block;
  -- Try to return remaining queued requests with EndOfInput rather
  -- than discarded
  while (not empty of getCharQ) repeat
    block declare
      getChar: getCharIntf;
    begin
      receive getChar from getCharQ;
      return getChar exception EndOfInput;
    end block;
  end while;
  discard getCharQ;
  
  while (not empty of getStringQ) repeat
    block declare
      getString: getStringIntf;
    begin
      receive getString from getStringQ;
      return getString exception EndOfInput;
    end block;
  end while;
  discard getStringQ;
  
end process
