
ApplicationBuilder:
  using(Standard, StartWindowApplication, BBExternal, Adapter, Quit,
    QuitDispatcher)
  process (Init: WindowApplicationIn)
  declare
    Parms: WindowApplicationInterface; -- initialization callmessage
    Client: StandardOut; -- client process
    ParmString: Charstring; -- parameter to client process
    ClientPutLine: PutLineOut; -- PutLine from Client to Adapter
    ClientGetLine: GetLineOut; -- GetLine from Client to Buffer
    ClientGetPgm: GetProgramOut; -- GetProgram from Client to Adapter
  begin
    receive Parms from Init;
    block
      declare
        AdapterQuit: QuitOut; -- adapter's quit port
        BufferQuit: QuitOut; -- buffer's quit port
      begin
        call (AdapterOut # (create of Parms.GetProgram("adapter")))
          (Parms.WriteToWindow, Parms.WindowName, Parms.GetProgram,
          AdapterQuit, ClientPutLine, ClientGetPgm);
        call (BBout # (create of Parms.GetProgram("unboundedbuffer")))
          (0, Parms.InputToWindow, ClientGetLine, BufferQuit);
        call (QuitDispOut # (create of Parms.GetProgram("quitdispatcher")))
          (AdapterQuit, BufferQuit, Parms.Quit);
        Client := create of Parms.GetProgram(Parms.ProgramName);
        ParmString := Parms.ParmString;
        return Parms;
        -- note: fix this code
        block begin
        call Client(ClientGetLine, ClientPutLine, ClientGetPgm, ParmString);
      on (others)
      end block;
    on (others)
      return Parms exception NotCreated;
    end block;
  end process
  
