
Compound:  using(Standard, Filter) process(Init: StandardIn)
  declare
    Parms: StandardInterface; -- initialization callmessage
    Filter: FilterOut; -- port to initialize filter
    Client: StandardOut; -- port to initialize client
    CliToFil: PutLineOut; -- output port connected to filter
    ClientName: charstring; -- name of client program
    Arguments: charstring; -- arguments to client program
    Mark: integer; -- position of "/" delimiting name/parameters
  begin
  -- code for process compound
  
    receive Parms from Init;
    block begin
    ClientName := "filter";
      Filter := create of Parms.GetProgram(ClientName);
      Mark := position of C in Parms.ParmString where(C = '/');
      ClientName := every of C in Parms.ParmString where(position of C < Mark);
      Arguments := every of C in Parms.ParmString where(position of C > Mark);
      Client := create of Parms.GetProgram(ClientName);
      call Filter(Parms.PutLine, "TheFilter", CliToFil);
      call Client(Parms.GetLine, CliToFil, Parms.GetProgram, Arguments);
    on (NotFound)
      call Parms.PutLine("compound: Syntax Error.");
    on (GetProgramInterface.NotFound)
      call Parms.PutLine("compound: " | ClientName | " not found.");
    on (InterfaceMismatch)
      call Parms.PutLine("compound: "| ClientName |
        " interface mismatch.");
    end block;
  return Parms;
  
end process

