
-- EXAMPLE_TYPE PROCESS_MODULE
tutorial_029 : using(Standard, WMExternal, WMInt, StartWindowApplication)
  process (Init: WMIn)
  declare
    Parms: WMInterface; -- initialization parameters
    Dispatch: DispatchIn; DispatchCM: DispatchInterface;
    Refocus: WindowIn; RefocusCM: WindowInterface;
    Kill: WindowIn; KillCM: WindowInterface;
    Create: CreateIn; CreateCM: CreateInterface;
    WriteToWindow: WriteToWindowIn; WriteToWindowCM: WriteToWindowInterface;
    GetProgram: GetProgramOut;
    PutLine: PutLineOut;
    WriteToWindowCapability: WriteToWindowOut;
    ApplicationBuilder: Program;
    Lines: integer; -- number of lines since last prompt
    CreatedWindows: Windows; -- status of all windows
    CurrentFocus: Charstring; -- name of window in focus
    CurrentWindow: Window; -- a window being insert/deleted/searched
  begin
    -- initialization section
    receive Parms from Init;
    GetProgram := Parms.GetProgram;
    PutLine := Parms.PutLine;
    ApplicationBuilder := Parms.GetProgram("ApplicationBuilder");
    new Dispatch; connect Parms.Dispatch to Dispatch;
    new Refocus; connect Parms.Refocus to Refocus;
    new Kill; connect Parms.Kill to Kill;
    new Create; connect Parms.Create to Create;
    new WriteToWindow; connect WriteToWindowCapability to WriteToWindow;
    Lines := 0;
    new CreatedWindows;
    CurrentFocus := ":";
    -- service section
    while ('true') repeat
        if Lines = 20
          then
            call PutLine(CurrentFocus | ":");
            Lines := 0;
          end if;
        select
        event Dispatch  --
        -- EXAMPLE_TYPE STATEMENTS
        
        block begin
            receive DispatchCM from Dispatch;
            inspect W in CreatedWindows[DispatchCM.WindowName]
              begin
                call W.InputToWindow(DispatchCM.Line);
              end inspect;
          on(NotFound)
          end block;
          
          
          event Refocus  --
          event Kill  --
          event Create  --
          event WriteToWindow  --
          otherwise
          end select;
        Lines := Lines + 1;
      end while;
  end process
