#include "includefile"

/* files from the ../include directory */
INCFILES = li.h stdnil.h listp.h procenv.h table.h avltree.h tblrep.h \
		sysdep.h storage.h accessors.h

/* files from the interface/cd directory */
CDFILES = predefined.cd interpform.cd

all:	imports.power headers

imports.power: exports.power
	( echo "#!" ; cat exports.power ) > imports.power

/* following weird looking stuff is to make sure we can make the target */
/* in our development system, where the files are kept under SCCS */
/* control (so they will make it into the snapshots) but checked out */
/* (since they're not really source files, at least not in this */
/* directory).  So we want to make sure we don't copy in read-only */
/* versions of the files. */
headers:
	-@ rm -rf transfer
	mkdir transfer
	( cd $(HROOT)/include ; tar cf - $(INCFILES) ) | \
		( cd transfer ; tar xf - )
	( cd $(HROOT)/interface/cd ; tar cf - $(CDFILES) ) | \
		( cd transfer ; tar xf - )
	chmod +w transfer/?*
	mv transfer/?* .
	rmdir transfer


/* Make sure the most recent version of all our copied header files are */
/* checked in in this directory */
package: headers
	- cp $(HROOT)/update_sccs $(BINDIR)
	- chmod +x $(BINDIR)/update_sccs
	$(BINDIR)/update_sccs $(INCFILES) $(CDFILES)
	-rm -f $(BINDIR)/update_sccs

clean::
	rm -f imports.power $(INCFILES) $(CDFILES)
