/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)sysdep.h	1.13 2/15/91 */

#ifndef sysdep_included

/******************************************************************************
 * SYSTEM DEPENDENT PARAMETERS
 *****************************************************************************/

/* change the following if your machine is not a 32-bit architecture */

#define INTSIZE                        32
#define MININT                -2147483647
#define MAXINT                 2147483647
#define MAXCOUNTER ((unsigned) 4294967295)
#define SIGNBIT			0x80000000

/* union_va_arg() macro.
   On the sparc, unions are passed by copying them onto the stack and passing
   a pointer to the result.  On the sun3, the union is passed directly.
   Normally, this is transparent because the sparc compiler turns u.f into
   u->f in the callee.  However, when varargs is used, this information is
   lost and has to be specified manually.  Hence the crazy macro.
 */
   
#ifdef sparc
#define union_va_arg(argvec,type) * (va_arg(argvec,type *))
#else
#define union_va_arg(argvec,type) (va_arg(argvec,type))
#endif

/* define HAVE_VXPRINTF if vprintf, vfprintf, vsprintf are available */
#ifndef ibm032
#define HAVE_VXPRINTF
#endif

/* define HAVE_XDRFREE if your xdr library has xdr_free() */
#if ! (defined(ibm032) || defined(sgi))
#define HAVE_XDRFREE
#endif

/* define COMPLETE_STDIO if your stdio has ctermid, cuserid, tmpfile, and */
/* tmpnam; otherwise don't define it. */
#if !defined(ibm032) && !defined(NeXT)
#define COMPLETE_STDIO
#endif

/* Set to alignment size needed for allocated storage blocks, 1 if */
/* no alignment required */
#if defined(sparc) || defined(mips)
#define STGALIGN 4
#else
#define STGALIGN 1
#endif

/* Define this if your machine supports more than 32 file descriptors and */
/* the svc_getreqset() rpc call instead of svc_getreq() */

#if defined(sun) || defined(sgi) || defined(_AIX) || defined(__convex__) || defined(NeXT)
#define FDSETS
#endif

#endif
#define sysdep_included
