-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
events:  USING (times)

DEFINITIONS

-- Fundamental structures for storing data 

	An_Event: record (
		Scheduled_Time: Time_range,
		Organizer: charstring,
		Participants: Member_IDs,
		Planned_At: Time_range,
		Annotation: charstring,
		Location: charstring,
		Event_ID: Event_ID );

	Table_Of_Events : table of An_Event { full } keys (Event_ID);

	Event_ID: nominal ;

	Member_IDs : table of charstring {full} keys (*);
	
	Members : table of Member {full} ;


	Member : record (
		Name : charstring,
		Office : charstring,
		Phone : charstring,
		Member_ID : charstring );


END DEFINITIONS
